// Copyright (c) 2015, XMOS Ltd, All rights reserved
/**
How to output data accompanied by a data valid signal
-----------------------------------------------------

A clocked port can generate a second strobe signal whenever data is
output. If a port is setup this way, whenever the program drives the
port it will also drive a the data valid signal on a different port.
**/


#include <xs1.h>

in           port   inClock = XS1_PORT_1B;

/**
    The following declarations provide an 8-bit output port, a secondary
    output port for the valid signal and a clock block to clock the ports
**/


out buffered port:8 outP    = XS1_PORT_4B;
out          port   outR    = XS1_PORT_1A;
clock               clk     = XS1_CLKBLK_1;


int main(void) {
  configure_clock_src(clk, inClock);
/**
The following statement configures the output port 'outP' to drive the
port 'outR' high whenever data is output. The port used as a "ready
out" signal must be 1-bit wide.
**/

  configure_out_port_strobed_master(outP, outR, clk, 0);
  start_clock(clk);

/**
The port drives two 4-bit values over two clock periods, raising the
readyOut signal during this time.
**/

  outP <: 0x85;
/**
It is also possible to implement control flow algorithms that output
data using a readyIn strobe signal and input data using a readyOut
strobe signal; when both signals are configured, the port implements a
symmetric strobe protocol that uses a clock to handshake the
communication of the data.
**/

  return 0;
}

