// Copyright (c) 2015, XMOS Ltd, All rights reserved
/**
How to input data accompanied by a data valid signal
----------------------------------------------------

A clocked port can interpret a "ready-in" strobe signal that
determines the validity of the accompanying data. For example, you can
setup a program to only input data from a clocked port only when an
associated signal is high.
**/


#include <xs1.h>

in buffered port:8 inP     = XS1_PORT_4A;
in          port   inReady = XS1_PORT_1A;
in          port   inClock = XS1_PORT_1B;
clock              clk     = XS1_CLKBLK_1;

int main(void) {
  configure_clock_src(clk, inClock);

/**
The following statement configures the input port 'inP' to be sampled
only when the value sampled on the port 'inReady' equals 1. The port
used as a data valid signal must be 1-bit wide.
**/


  configure_in_port_strobed_slave(inP, inReady, clk);
  start_clock(clk);

/**
Data is sampled on the rising edge of the clock whenever the signal on
the port 'inReady' is high.
**/


  inP :> void;
  return 0;
}

