// Copyright (c) 2015, XMOS Ltd, All rights reserved
/**
How to output on multiple ports in parallel
-------------------------------------------

By configuring more than one buffered port to be clocked from the same
source, a single thread can cause data to be driven in parallel on
these ports.
**/


#include <xs1.h>

out buffered port:4 out_port_a = XS1_PORT_4A;
out buffered port:4 out_port_b = XS1_PORT_4B;
clock clk = XS1_CLKBLK_1;

int main(void) {
  configure_clock_rate(clk, 100, 8);
  configure_out_port(out_port_a, clk, 0);
  configure_out_port(out_port_b, clk, 0);
  start_clock(clk);

  out_port_a <: 0;

  /** The statement:
   **/

  sync(out_port_a);

/**
  causes the processor to wait until the next falling edge on which the
  last data in the buffer has been driven for a full period, ensuring
  that the next instruction is executed just after a falling edge.  This
  ensures that the subsequent two output statements in the loop:
**/


  for(char c = 'A'; c <= 'Z'; ++c) {
    out_port_a <: (char) (c & 0xF0) >> 4;
    out_port_b <: (char) (c & 0x0F);
  }

  /** are both executed in the same clock period.
   **/

  return 0;
}
