// Copyright (c) 2015, XMOS Ltd, All rights reserved
/**
How to input on multiple ports in parallel
------------------------------------------

By configuring more than one buffered port to be clocked from the same
source, a single thread can cause data to be sampled in parallel on
these ports.
**/


#include <xs1.h>

in buffered port:4 in_port_a = XS1_PORT_4A;
in buffered port:4 in_port_b = XS1_PORT_4B;
clock clk = XS1_CLKBLK_1;

int main(void) {
  int in_val_a;
  int in_val_b;

  configure_clock_rate(clk, 100, 8);
  configure_in_port(in_port_a, clk);
  configure_in_port(in_port_b, clk);
  start_clock(clk);

  in_port_a :> void;

  /** The statement:
   **/

  sync(in_port_a);

/**
  causes the processor to wait until the next falling edge on which the
  last data in the buffer has been sampled for a full period, ensuring
  that the next instruction is executed just after a falling edge.  This
  ensures that the subsequent two input statements in the loop
**/


  while(1) {
    in_port_a :> in_val_a;
    in_port_b :> in_val_b;
  }

  /** are both executed in the same clock period.
   **/

  return 0;
}
