// Copyright (c) 2015, XMOS Ltd, All rights reserved
/**
How to control port output data rates with timers
-------------------------------------------------
**/


#include <xs1.h>

out port toggle_port = XS1_PORT_1A;

int main(void) {
/**
  The rate at which data is output to a port can be controlled by using
  one of the xCORE's pool of timer resources.  This example uses a timer
  to toggle the output of port 'toggle_port' every 500ms.
**/


  #define DELAY 50000000 //(50,000,000 * 10ns = 0.5s)
  unsigned state = 1, time;
  timer t;
  t :> time;

  while(1) {
    // Output the value of variable 'state' to port 'toggle_port'
    toggle_port <: state;
    // Increment the variable 'time' by the value 'DELAY'
    time += DELAY;
    // Use the timer 't' to wait until this time delay is reached. 
    t when timerafter(time) :> void;
    // Toggle the value of variable 'state' and repeat the process again. 
    state = !state;
  }

  return 0;
}

/**
The ability to control output on a port can also be achieved using the
ports time operator '@'.  Note however that the ports time operator is
16-bit whereas the processor timer resource is 32-bit. See example
"How to perform timed output on a port" for further information
**/

