// Copyright (c) 2015, XMOS Ltd, All rights reserved
/**
How to wait for a condition on an input port
--------------------------------------------

An input operation can be made to wait for one of two conditions on a
port: equal to ('pinseq') or not equal to ('pinsneq') some value.
**/


#include <xs1.h>

in port input_port = XS1_PORT_1A; // ports must be declared as a global variable

int main() {

  int input_value;
  int counter = 0;

  //obtain initial reading from the port
  input_port :> input_value;
  while(1) {
/**
    The following statement instructs 'input_port' to wait until the value
    seen on its pins is not equal to 'input_value' before sampling and
    providing it to the processor to store in 'input_value'.
**/

    input_port when pinsneq(input_value) :> input_value;
    counter++;
  }

  return 0;
}
