// Copyright (c) 2015, XMOS Ltd, All rights reserved
#include <print.h>

/**
How to use pass-by-reference in XC
----------------------------------

In XC you can pass function parameters "by reference". Any changes to
pass-by-reference parameters will also change the original variable
passed in by the calling function.

For example, the following function takes a reference parameter 'x'
and adds 10 to it.
**/


void add10(int &x)
{
  x += 10;
}


int main() {
  /** This function can then be called and the argument will be updated
   **/

  int y=5;

  add10(y);

  printintln(y);  // This will print out 15


  return 0;
}
