// Copyright (c) 2015, XMOS Ltd, All rights reserved
#include <stdio.h>
#include <xs1.h>
/**
 How to use nullable types
 -------------------------
**/


port p = XS1_PORT_1A;

/**
 Resource types (e.g. ports, timers etc) and reference types can be
 made *nullable*. This means that their value could be a normal value
 or could be the special value 'null'. The '?' type operator creates a
 nullable type.
 
 For example the following function has a nullable port argument:
**/


void f(port ?p)
{
  if (!isnull(p)) {
    printf("Outputting to port\n");
    p <: 0;
  }
}

/**
    The 'isnull' function tests whether a variable of nullable type is
    null or not.
**/


/**
    Functions taking nullable arguments can either be passed a value or
    the 'null' value:
**/


void g() {
  f(null);
  f(p);
}


int main() {
  g();
  return 0;
}
