// Copyright (c) 2015, XMOS Ltd, All rights reserved
/**
How to specify that two functions must be placed in the same overlay
--------------------------------------------------------------------

You can associate a name with the overlay containing an overlay root
by specifying the overlay name in the overlay attribute as follows:
**/

[[overlay(overlay_name)]] void f() {}

/**
Specify the same overlay name multiple times forces two functions into
the same named overlay. For example:
**/


[[overlay(foo)]] void g() {}
[[overlay(foo)]] void h() {}

/**
'f' and 'g' will be placed in the same overlay. All the code and read
only data that is only referenced from 'f' or 'g' will be placed in
this overlay. The overlay will be loaded into memory when either one
of 'f' and 'g' is called.
**/


int main()
{
  f();
  g();
  h();
  return 0;
}
