// Copyright (c) 2016, XMOS Ltd, All rights reserved
#include <stdio.h>
#include <platform.h>
/**
How to use a par statement across multiple tiles
------------------------------------------------

The 'par' construct takes a set of statements (usually function calls)
and runs them in parallel. By default each task runs on a separate
logical core.
**/



void task1(int x)
{
  printf("Hello world - %d\n", x);
}

void task2()
{
  printf("Hello Universe\n");
}

int main()
{

/**
  The 'on' construct allows you to place tasks on different tiles. For
  example:
**/


  par {
    on tile[0]: task1(5);
    on tile[1]: task2();
  }

/**
    You can only do this from the 'main' function and must include the
    'platform.h' header file.
**/

  return 0;
}

