// Copyright (c) 2015, XMOS Ltd, All rights reserved
#include <print.h>
/**
How to pass movable pointer arguments
-------------------------------------

Movable pointers can be passed to arguments marked movable using the
'move' operator. However, they can also be passed to other kinds of
pointer arguments but if the movable pointer is a global then you
cannot reference it within the called function:
**/


int i = 32;
int * movable y = &i;

void func1(int * x) {
  printintln(*x);
  // Cannot reference y here
}

void func2() {
  func1(y);
}

int main() {
  func2();
  return 0;
}
