// Copyright (c) 2015, XMOS Ltd, All rights reserved
#include <print.h>
#include <xs1.h>

// Dummy function
void foo() {}

int main() {
  timer t;
  unsigned int start_time, end_time;
/**
  How to measure elapsed time using a timer
  -----------------------------------------
  
  Timers can be used to measure the amount of time elapsed between two
  statements. First input the current time from the timer:
**/

  t :> start_time;
  foo();
/**
  After performing the action you wish to time, input the time from the
  timer again:
**/

  t :> end_time;
/**
  The difference between the two times gives you the number of timer
  ticks elapsed.
**/

  printstr("Number of timer ticks elapsed: ");
  printintln(end_time - start_time);
/**
  This method can be used to measure durations of up to 2 ^32 -1 timer
  ticks (approximately 42 seconds).
**/

  return 0;
}
