// Copyright (c) 2015, XMOS Ltd, All rights reserved
#include <stdio.h>

interface my_interface {
  void fA(int x, int y);
};

/**
How to use interfaces to connect to multiple tasks
--------------------------------------------------

The following example shows three tasks running in parallel and
communicating. The 'task3' function performs transactions with either
'task1' or 'task2'.
**/


void task1(interface my_interface client c) {
  c.fA(5, 10);
}

void task2(interface my_interface client c) {
  c.fA(20, 25);
}

void task3(interface my_interface server c,
           interface my_interface server d) {
  for (int i=0; i < 2; i++) {
    // wait for either fA or fB over connection c.
    select {
    case c.fA(int x, int y):
      printf("Received fA from interface end c: %d, %d\n", x, y);
      break;
    case d.fA(int x, int y):
      printf("Received fA from interface end d: %d, %d\n", x, y);
      break;
    }
  }
}

int main(void) {
  interface my_interface c;
  interface my_interface d;
  par {
    task1(c);
    task2(d);
    task3(c, d);
  }
  return 0;
}

/**
Note: You can also connect to multiple tasks over the same interfaces
  using interface arrays.
**/

