// Copyright (c) 2015, XMOS Ltd, All rights reserved
#include <print.h>
#include <string.h>
/**
How to use memcpy with interface array arguments
------------------------------------------------

Interface functions can take array arguments like normal functions:
**/


interface my_interface {
  void fill_buffer(int buf[n], unsigned n);
};


/**
At the server end of the interface, the 'memcpy'  in 'string.h' can be
used to copy local data to the remote array. This will be converted
into an efficient inter-task copy.
**/

void task2(server interface my_interface c)
{
  int data[5] = {1,2,3,4,5};
  select {
  case c.fill_buffer(int a[n], unsigned n):
    // Copy data from the local array to the remote
    memcpy(a, data, n*sizeof(int));
    break;
  }
}


void task1(client interface my_interface c)
{
  int a[5] = {0,0,0,0,0};

  // Print out the array before the call
  for (int i = 0; i < 5; i++)
    printintln(a[i]);

  c.fill_buffer(a, 5);

  // Print out the filled up array
  for (int i = 0; i < 5; i++)
    printintln(a[i]);
}

int main() {
  interface my_interface c;
  par {
    task1(c);
    task2(c);
  }
  return 0;
}
