// Copyright (c) 2015, XMOS Ltd, All rights reserved
#include <print.h>
/**
How to return values via interface calls
----------------------------------------

Interface functions can return values. You declare them in the
interface declaration as you would for a normal function:
**/


interface my_interface {
  int get_value(void);
};

/**
The client end of the interface can use the results of that interface
function call:
**/


void task1(client interface my_interface c) {
  int x;
  x = c.get_value();
  printintln(x);
}

/**
When handling the function at the server end, you can declare a
variable to hold the return value in the select case. This can be
assigned in the body of the case and at the end of the case the value
is returned back to the client.
**/

void task2(server interface my_interface c) {
  int data = 33;
  select {
  case c.get_value() -> int return_val:
    // Set the return value
    return_val = data;
    break;
  }
}


int main() {
  interface my_interface c;
  par {
    task1(c);
    task2(c);
  }
  return 0;
}
