// Copyright (c) 2015, XMOS Ltd, All rights reserved
#include <print.h>
/**
How to pass pointers over interface calls
-----------------------------------------

Interface functions can take pointer arguments:
**/


interface my_interface {
  void msg(int *p);
};

/**
The client end can then pass a pointer into the function:
**/


void task1(client interface my_interface c)
{
  int a[5] = {0,1,2,3,4};
  int *p = &a[0];
  c.msg(p);
}

/**
On the server end the select case can access memory via the pointer.
**/

void task2(server interface my_interface c)
{
  select {
  case c.msg(int *p):
    printintln(*p);
    printintln(*(p+2));
    break;
  }
}

/**
Since passing the pointer implies that both tasks need access to the
same memory space, if an interface includes a function that passes
pointers, you cannot use it between tasks on different tiles.
**/


int main() {
  interface my_interface c;
  par {
    task1(c);
    task2(c);
  }
  return 0;
}
