// Copyright (c) 2015, XMOS Ltd, All rights reserved
#include <print.h>

int main() {
  int a, b = 1, c = 2, d = 4;
/**
  How to use the earlyclobber inline assembly constraint
  ------------------------------------------------------
  
  Normally the compiler assumes all input operands are read before any
  of the output operands are written. If an input operand is unused
  after the 'asm' statement the compiler may decide to place the input
  operand in the same register as one of the output operands.
  
  The earlyclobber constraint modifier "&" can be used to specify that
  an output operand is modified before all input operands are consumed.
**/

  asm("or %0, %1, %2\n"
      "or %0, %0, %3\n"
      : "=&r"(a)
      : "r"(b), "r"(c), "r"(d));

/**
  The compiler will place the output operand in a different register to
  all the input operands.
**/


  printintln(a); // Should print 7
  return 0;
}
