// Copyright (c) 2015, XMOS Ltd, All rights reserved
#include <platform.h>
#include <xs1.h>
/**
How to load overlays from a SPI flash
-------------------------------------

An overlay is a block of code and data that is loaded on demand at
runtime. Each overlay has a predetermined region of memory that it is
copied to called an overlay region. Several overlays may be associated
with the same overlay region, but only one of these overlay can be
loaded at any one time.

Overlays reduce the amount of memory needed to run your application
since it is no longer necessary to reserve space for all your code and
data - instead the tools only need to reserve space for the largest
overlay that can be loaded into each overlay region.

Specify the '-foverlay=flash' option when building your application to
link against the flash overlay runtime. To use this runtime the
application must be booted from flash. The runtime loads overlays from
the same flash device or flash devices used for boot.

Include the following file:
**/


#include <overlay_flash.h>

/**
Declare a movable pointer to the SPI ports.
**/


fl_SPIPorts spi_ports = {
  PORT_SPI_MISO,
  PORT_SPI_SS,
  PORT_SPI_CLK,
  PORT_SPI_MOSI,
  XS1_CLKBLK_1
};

fl_SPIPorts * movable spi_ports_ptr = &spi_ports;


[[overlay]]
void first()
{
  // Put code for first overlay here...
}

[[overlay]]
void second()
{
  // Put code for second overlay here...
}

int main()
{
/**
  Call 'overlay_flash_init' to initialize the flash overlay runtime:
**/

  overlay_flash_init(move(spi_ports_ptr), 100, 8);
/**
  The SPI clock frequency in MHz is specifed as a ratio using the last
  two arguments of 'overlay_flash_init'. In this case the clock
  frequency is set to 12.5 MHz (i.e. 100 / 8).
**/


  first();
  second();

  return 0;
}
