// Copyright (c) 2015, XMOS Ltd, All rights reserved
/**
How to examine the value of a variable
--------------------------------------

XGDB can be used to examine the value of a particular variable at a
given point in time. For example, compile the following code ensuring
that debug is enabled (-g):
**/

int add1(int x) {
  return x + 1;
}

int main() {
  add1(12);
  return 0;
}

/**
Create a new debug configuration via *Run->debug Configurations->xCORE
Applications*. Set a breakpoint at the start of *add1* then start
debugging. Execution will now break when *add1* is reached. The
current value of the parameter *x* can be seen by hovering over the
variable in the editor. Alternatively, the values for all of the
variables currently in scope can been found in the *Variables* view.

On the command line, variables can examined using the *print* command.
For example, start XGDB, connect to the simulator and set a breakpoint
on *add1*. When run, execution will break at the start of *add1*. You
can now display the value of the parameter *x* using the *print*
command as follows:

   > xgdb a.xe
   ...etc...
   (gdb) connect -s
   0xffffc04e in ?? ()
   (gdb) b add1
   Breakpoint 1 at 0x100b2: file examining_variables.xc, line 11.
   (gdb) run
   ...etc...
   Breakpoint 1, add1 (x=12) at examining_variables.xc:11
   11    return x + 1;
   (gdb) print x
   $1 = 12
   (gdb) print /x x
   $2 = 0xc

Note: The print command accepts an argument specifying the desired
format. In the above example, the '\/x' argument can be used to
display the value in hex.
**/


