// Copyright (c) 2016, XMOS Ltd, All rights reserved
/**
How to examine the stack contents
---------------------------------

XGDB can be used to examine the contents of the stack memory at a
given point in time. For example, compile the following code ensuring
that debug is enabled (-g):
**/

int add1(int x) {
  return x + 1;
}

int sub1(int x, int y) {
  return add1(x) - add1(y);
}

int main() {
  sub1(6, 3);
  return 0;
}

/**
Create a new debug configuration via *Run->debug Configurations->xCORE
Applications*. Set a breakpoint at the start of *add1* then start
debugging. Execution will now break when *add1* is reached. The
contents of the stack can be viewed from the *Debug* view. Note:
Clicking on the previous stack frames in the *Debug* view causes the
*Variables* view to be updated with the variables in scope for this
stack frame.

On the command line, stack contents can be displayed using the
*backtrace* command. For example, start XGDB, connect to the simulator
and set a breakpoint on *add1*. When run, execution will break at the
start of *add1*. You can display the stack contents using the
*backtrace* command as follows:

   > xgdb a.xe
   ...etc...
   (gdb) connect -s
   0xffffc04e in ?? ()
   (gdb) b add1
   Breakpoint 1 at 0x100b2: file examining_the_stack.xc, line 9.
   (gdb) r
   ...etc...
   Breakpoint 1, add1 (x=6) at examining_the_stack.xc:9
   9     return x + 1;
   (gdb) backtrace
   #0  add1 (x=6) at examining_the_stack.xc:9
   #1  0x000100ca in sub1 (x=6, y=3) at examining_the_stack.xc:13
   #2  0x000100e4 in main () at examining_the_stack.xc:17
**/


