// Copyright (c) 2015, XMOS Ltd, All rights reserved
#include <stdio.h>
/**
 How to pass the array bound as a parameter
 ------------------------------------------
**/


/**
 You can pass the safe array bound used for checking as a parameter.
 For example:
**/


int sum(int a[n], unsigned n)
{
  int x = 0;
  for (int i = 0; i < n; i++) {
    x += a[i];
  }
  return x;
}

/**
    This method allows the compiler to reason about the checks and
    eliminate them at compile time. For example, in the code above it can
    know that none of the array reads are out of bounds since it knows
    that 'n' is the number of elements in the array and the loop only goes
    up to 'n'.
**/




int main()
{

/**
   Nothing special is required when calling these functions. The
   arguments can be passed as normal:
**/


  int a[5] = {0, 1, 2, 3, 4};
  printf("Sum of array is %d\n", sum(a, 5));

  return 0;
}
