// Copyright (c) 2015, XMOS Ltd, All rights reserved
/**
How to use array bounds checks
------------------------------

Arrays are *safe* by default and are represented by their base pointer
and a number of elements:

+--------------------+----------------------+
| base pointer       | number of elements   |
+--------------------+----------------------+

These bounds allow array accesses to be checked at the point of
access.

You do not need to do anything special to use the bound checks. Any
declared array has them.
**/


int x[10];

/**
If this array is accessed outside its bounds, it will cause an
exception. This is true even via function calls.
**/


int f(int y[]) {
  // This will cause an exception if the array 'x' of only 10 elements is
  // passed to it
  return y[11];
}


int main() {
  f(x);
  return 0;
}
