// Copyright (c) 2015, XMOS Ltd, All rights reserved
#include <platform.h>
#include <stdio.h>

#define DELAY 25000000

on tile[0] : port led_ports = XS1_PORT_4F;

int main(void)
{
  par
  {
    on tile[0]:
    {
      char led_pattern[8];
      int time;
      int i = 0;
      timer t;

      char red   = 8;
      char green = 4;
      char blue  = 2;

      char single = 1;

      led_pattern[0] =          red;
      led_pattern[1] = single | red | green;
      led_pattern[2] =                green;
      led_pattern[3] = single |       green | blue;
      led_pattern[4] =                        blue;
      led_pattern[5] = single | red |         blue;
      led_pattern[6] =          red | green | blue;
      led_pattern[7] = single;

      t :> time;

      while (1) {
        led_ports <: led_pattern[i];
        i++;
        if (i == 8) {
          i = 0;
        }

        t when timerafter(time + DELAY) :> time;
      }
    }

    on tile[1]:
    {
      while(1);
    }
  }

  return 0;
}
