

#include <stdio.h>
#include <math.h>
#include <stdlib.h>
#include <print.h>
#include <cyg/kernel/kapi.h>
/* now declare (and allocate space for) some kernel objects,
   like the two threads we will use */
cyg_thread thread_s[2];		/* space for two thread objects */

char stack[2][4096];		/* space for two 4K stacks */

/* now the handles for the threads */
cyg_handle_t simple_threadA, simple_threadB;

/* and now variables for the procedure which is the thread */
cyg_thread_entry_t simple_program;

/* and now a mutex to protect calls to the C library */
cyg_mutex_t cliblock;
externC void hal_hardware_init(void);
/* we install our own startup routine which sets up threads */
void cyg_start(void)
{
  hal_hardware_init();
  printstr("Entering twothreads' cyg_user_start() function\n");

  cyg_mutex_init(&cliblock);

  cyg_thread_create(4, simple_program, (cyg_addrword_t) 0,
		    "Thread A", (void *) stack[0], 4096,
		    &simple_threadA, &thread_s[0]);

  cyg_thread_resume(simple_threadA);

  cyg_thread_create(5, simple_program, (cyg_addrword_t) 1,
		    "Thread B", (void *) stack[1], 4096,
		    &simple_threadB, &thread_s[1]);

  cyg_thread_resume(simple_threadB);

  cyg_scheduler_start();
}

/* this is a simple program which runs in a thread */
void simple_program(cyg_addrword_t data)
{
  int message = (int) data;
  int delay;

  printstr("Beginning execution; thread data is ");
  printintln(message);
#define SIM_RUN 1
#ifndef SIM_RUN
  cyg_thread_delay(200);
#else
  cyg_thread_delay(10);
#endif //SIM_RUN

  for (;;) {
#ifndef SIM_RUN
    delay = 200 + (rand() % 50);
#else
    do {
        delay = rand() % 5;
    } while (delay == 0);

#endif //SIM_RUN
    /* note: printf() must be protected by a
       call to cyg_mutex_lock() */
    cyg_mutex_lock(&cliblock); {
    printstr("Thread ");
    printint(message);
    printstr(": and now a delay of ");
    printint(delay);
    printstrln(" clock ticks");

      //printf("Thread %d: and now a delay of %d clock ticks\n",
	   //  message, delay);
    }
    cyg_mutex_unlock(&cliblock);

   cyg_thread_delay(delay);
  }
} //end: simple_program
