//==========================================================================
//
//      xmos_hal_bsp_misc.xc
//
//      HAL misc board support code for XMOS architecture
//
//==========================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####
// -------------------------------------------
// This file is part of eCos, the Embedded Configurable Operating System.
// Copyright (C) 1998, 1999, 2000, 2001, 2002 Free Software Foundation, Inc.
//
// eCos is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 or (at your option) any later
// version.
//
// eCos is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
// for more details.
//
// You should have received a copy of the GNU General Public License
// along with eCos; if not, write to the Free Software Foundation, Inc.,
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
//
// As a special exception, if other files instantiate templates or use
// macros or inline functions from this file, or you compile this file
// and link it with other works to produce a work based on this file,
// this file does not by itself cause the resulting work to be covered by
// the GNU General Public License. However the source code for this file
// must still be made available in accordance with section (3) of the GNU
// General Public License v2.
//
// This exception does not invalidate any other reasons why a work based
// on this file might be covered by the GNU General Public License.
// -------------------------------------------
// ####ECOSGPLCOPYRIGHTEND####
//==========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):    XMOS
// Contributors: XMOS
// Date:         2014-02-19
// Purpose:      HAL board support
// Description:  Implementations of HAL board interfaces
//
//####DESCRIPTIONEND####
//
//========================================================================*/

#if 0
#include <pkgconf/hal.h>
#include <pkgconf/system.h>
#include CYGBLD_HAL_PLATFORM_H

#include <cyg/infra/cyg_type.h>         // base types
#include <cyg/infra/cyg_trac.h>         // tracing macros
#include <cyg/infra/cyg_ass.h>          // assertion macros

#include <cyg/hal/hal_io.h>             // IO macros
#include <cyg/hal/hal_arch.h>           // Register state info
#include <cyg/hal/hal_diag.h>
#include <cyg/hal/hal_intr.h>           // Interrupt names
#include <cyg/hal/hal_cache.h>
#include <cyg/hal/aaed2000.h>           // Platform specifics

#include <cyg/infra/diag.h>             // diag_printf

#include <string.h> // memset
#endif

#include <cyg/hal/hal_arch.h>           // Register state info
#include <cyg_type.h>
#include <xs1.h>
#include <hwtimer.h>
#include <print.h>


#ifndef CYGNUM_HAL_RTC_NUMERATOR
//#define CYGNUM_HAL_RTC_NUMERATOR     1000000
//#define CYGNUM_HAL_RTC_DENOMINATOR   100000
#define CYGNUM_HAL_RTC_NUMERATOR     1000000000
#define CYGNUM_HAL_RTC_DENOMINATOR   60
#define CYGNUM_HAL_RTC_PERIOD        9999
#endif

//
// Platform specific initialization
//
hwtimer_t tickclock; // timer to generate clock interrupts
unsigned long timertick = (unsigned long)(CYGNUM_HAL_RTC_NUMERATOR / CYGNUM_HAL_RTC_DENOMINATOR);
HAL_SavedRegisters hal_saved_registers;
unsigned int hal_regs_save_flag;    //Registers have to be saved when there is an interrupt
int test_ctr;

#define KSTACK_SIZE	512	  //FixME: to specify from cyg_user application
unsigned int next_int;    // used by clock interrupt
long kstack[KSTACK_SIZE]; // kernel stack size in 32 bit words

// forward declaration of assembly functions used in C
void setup_clock_();
void restore_context_();
void init_system_();

//void hal_thread_init_context( CYG_ADDRESS stack_ptr, Cyg_Thread *thread, cyg_thread_entry *thread_entry, cyg_uint32 threadid );
void hal_thread_init_context( CYG_ADDRESS stack_ptr, CYG_ADDRESS thread, CYG_ADDRESS thread_entry, cyg_uint32 threadid );
void hal_thread_switch_context( CYG_ADDRESS to, CYG_ADDRESS from );
void hal_thread_load_context( CYG_ADDRESS to );

#if 1
externC void plf_hardware_init(void);

#pragma stackfunction 100
void
plf_hardware_init(void)
{
	/* XMOS specific start-up code to kick-off timer and attaching a handler*/
    init_system_();
}
#endif
#if 0
void isr_handler(void)
{
	/* Called by the portable layer each time a tick interrupt occurs. */
	/* may be the same as default isr handler? */
	test_ctr++;
	//if (100 == test_ctr) {
//    if (1) {
//	  printint(isr_ctr);
//	  test_ctr = 0;
//    }
}
#endif

//
// Support for platform specific I/O channels
//

void
plf_if_init(void)
{
	/* Any specific resource level init like channels, timers, clock etc?*/
    //aaed2000_KeyboardInit();
}

#if 0
externC void hal_thread_load_context( CYG_ADDRESS to );
/*{
//   RESTORE_CONTEXT(to)
}*/

externC void hal_thread_switch_context( CYG_ADDRESS to, CYG_ADDRESS from );
/*{

}*/
#endif
// -------------------------------------------------------------------------

void hal_clock_initialize(cyg_uint32 period)
{
	//FixMe: Explore more in order to associate ISR to RTC timer here
    // Use timer1 for the kernel clock
    timertick = period;

#if 0
    // Enable timer 0 interrupt
    *SA11X0_OIER |= SA11X0_OIER_TIMER0;

    // Unmask timer 0 interrupt
    HAL_INTERRUPT_UNMASK( CYGNUM_HAL_INTERRUPT_TIMER0 );
#endif
}

// This routine is called during a clock interrupt.
void hal_clock_reset(cyg_uint32 vector, cyg_uint32 period)
{
	//timertick = (unsigned long)(CYGNUM_HAL_RTC_NUMERATOR / CYGNUM_HAL_RTC_DENOMINATOR); //SE: fix crash
    timertick = period;
}

// Read the current value of the clock, returning the number of hardware
// "ticks" that have occurred (i.e. how far away the current value is from
// the start)

// Note: The "contract" for this function is that the value is the number
// of hardware clocks that have happened since the last interrupt (i.e.
// when it was reset).

void hal_clock_read(cyg_uint32 *pvalue)
{
    tickclock :> *pvalue;
    //FixMe: Need to check if the free running timer (rtc in this case)
}

//
// Delay for some number of micro-seconds
//   Use timer #3 which runs at [fixed] 7.3728 MHz
//   Since this is only a 16 bit counter, it may be necessary
//   to run a loop to achieve sufficiently large delay values.
//
// Note: The 7.3728MHz value does not seem to work in practice
// It seems to be off by about a factor of 2.
//
void hal_delay_us(cyg_int32 usecs)
{

}

int hal_lsbindex(int mask)
{
    int i;
    for (i = 0;  i < 32;  i++) {
      if (mask & (1<<i)) return ((cyg_uint32)i);
    }
    return ((int)-1);
}


// -------------------------------------------------------------------------

void hal_hardware_init(void)
{
    // Perform any platform specific initializations
    plf_hardware_init();

    // Set up eCos/ROM interfaces
    plf_if_init();

    //hal_clock_initialize(timertick);
    hal_clock_initialize(CYGNUM_HAL_RTC_PERIOD);

    //cyg_start(); //FixMe: chk if

}


// -------------------------------------------------------------------------

// This routine is called to respond to a hardware interrupt (IRQ).  It
// should interrogate the hardware and return the IRQ vector number.
int hal_IRQ_handler(void)
{
    /* Not relevent for XMOS */
    return 0;
}

//
// Interrupt control
//
/* FixMe: To explore more on the XS1 support for the below Interrupt control support */
/* XMOS interrupt control is not defined for now */

void hal_interrupt_mask(int vector)
{
    //asm volatile ("setsr  XS1_SR_IEBLE_MASK;");

}

void hal_interrupt_unmask(int vector)
{
    //asm volatile ("clrsr  XS1_SR_IEBLE_MASK;");
}

void hal_interrupt_acknowledge(int vector)
{
}

void hal_interrupt_configure(int vector, int level, int up)
{
#if 0
    cyg_uint16 _irr, _tmr, _trig;

    if (level) {
        if (up) {
            _trig = 0;     // level, high
        } else {
            _trig = 1;     // level, low
        }
    } else {
        if (up) {
            _trig = 2;     // edge, rising
        } else {
            _trig = 3;     // edge, falling
        }
    }

    switch (vector) {
    case  CYGNUM_HAL_INTERRUPT_TIMER:
        HAL_READ_UINT16(_FRV400_IRC_IRR5, _irr);
        _irr = (_irr & 0xFFF0) | ((vector-CYGNUM_HAL_VECTOR_EXTERNAL_INTERRUPT_LEVEL_1+1)<<0);
        HAL_WRITE_UINT16(_FRV400_IRC_IRR5, _irr);
        HAL_READ_UINT16(_FRV400_IRC_ITM0, _tmr);
        _tmr = (_tmr & 0xFFFC) | (_trig<<0);
        HAL_WRITE_UINT16(_FRV400_IRC_ITM0, _tmr);
        break;
    default:
        ; // Nothing to do
    };
#endif
}

void hal_interrupt_set_level(int vector, int level)
{
}
