#include <xs1.h>

// ----------------------------------------------------------------------------
//  hal_thread_init_context
//  Switch thread contexts
// R0: _sparg_ name of variable containing current sp, will be changed to new sp
// R1: _thread_ thread object address, passed as argument to entry point
// R2:_entry_ entry point address.
// R3: _id_ bit pattern used in initializing registers, for debugging.
//  R0 = R0 = arg1 = thread ptr
//  R1 = thread object address
//  R2 = thread entry point function
//  R3 = thread id

// Need to save/restore R4..R12, R13 (sp), R14 (lr)

.extern hal_thread_init_context
.globl hal_thread_init_context.nstackwords
.globl hal_thread_init_context.maxthreads
.globl hal_thread_init_context.maxtimers
.globl hal_thread_init_context.maxchanends
.linkset hal_thread_init_context.nstackwords, 0
.linkset hal_thread_init_context.maxthreads,  0
.linkset hal_thread_init_context.maxtimers,   0
.linkset hal_thread_init_context.maxchanends, 0

.cc_top hal_thread_init_context.func, hal_thread_init_context
.globl  hal_thread_init_context,"f{0}(ui,ui,ui,ui)"

hal_thread_init_context:
    ldaw  r3,     sp[0];    /* save current SP to r3, need to restore SP when leaving function */        \
    set   sp,     r0;      /* Load sp to save location of current thread */                              \
    mov   r0,     r1;      /* R0 = arg1 = thread ptr */                                                  \
    extsp 20;             /* make room on stack to save context */                                       \
    ldaw  r1,     sp[0];      /* SCK hack */                                                                \
    stw   r2,     sp[7];  /* save the link register */                                                   \
    stw   spc,    sp[1];  /* save the saved program counter register (must be sp[1]!) */                 \
    stw   ssr,    sp[2];  /* save the saved status register (must be sp[2]!) */                          \
    stw   sed,    sp[3];  /* save the saved exception data register (must be sp[3]!) */                  \
    stw   et,     sp[4];  /* save the event type register (must be sp[4]!) */                            \
    stw   dp,     sp[5];  /* save the data pointer */                                                    \
    stw   cp,     sp[6];  /* save the constant pool pointer */                                           \
    stw   r0,     sp[8];  /* save the general purpose registers r0-r11 R0 = arg1 = thread ptr */         \
    ldc   r0,     1;      /* load dummy debug values to scratch registers */                             \
    stw   r0,     sp[9];                                                                                 \
    ldc   r0,     2;      /* load dummy debug values to scratch registers */                             \
    stw   r0,     sp[10];                                                                                \
    ldc   r0,     3;      /* load dummy debug values to scratch registers */                             \
    stw   r0,     sp[11];                                                                                \
    stw   r1,     sp[12]; /* SCK hack */                                                                 \
    ldc   r0,     5;      /* load dummy debug values to scratch registers */                             \
    stw   r0,     sp[13];                                                                                \
    ldc   r0,     6;      /* load dummy debug values to scratch registers */                             \
    stw   r0,     sp[14];                                                                                \
    ldc   r0,     7;      /* load dummy debug values to scratch registers */                             \
    stw   r0,     sp[15];                                                                                \
    ldc   r0,     8;      /* load dummy debug values to scratch registers */                             \
    stw   r0,     sp[16];                                                                                \
    ldc   r0,     9;      /* load dummy debug values to scratch registers */                             \
    stw   r0,     sp[17];                                                                                \
    ldc   r0,     10;      /* load dummy debug values to scratch registers */                            \
    stw   r0,    sp[18];                                                                                 \
    ldc   r0,     11;      /* load dummy debug values to scratch registers */                            \
    stw   r0,    sp[19];                                                                                 \
    set   sp,     r3;    /* restore SP from r3 */                                                        \
    retsp 0                //FixMe: chk if this is reqd if we call branch
.cc_bottom hal_thread_init_context.func


// ----------------------------------------------------------------------------
//  hal_thread_switch_context
//  Switch thread contexts
//  R0 = address of sp of next thread to execute
//  R1 = address of sp save location of current thread

// Need to save/restore R4..R12, R13 (sp), R14 (lr)

.extern hal_thread_switch_context
.globl hal_thread_switch_context.nstackwords
.globl hal_thread_switch_context.maxthreads
.globl hal_thread_switch_context.maxtimers
.globl hal_thread_switch_context.maxchanends
.linkset hal_thread_switch_context.nstackwords, 0
.linkset hal_thread_switch_context.maxthreads,  0
.linkset hal_thread_switch_context.maxtimers,   0
.linkset hal_thread_switch_context.maxchanends, 0

.cc_top hal_thread_switch_context.func, hal_thread_switch_context
.globl  hal_thread_switch_context,"f{0}(ui,ui)"

hal_thread_switch_context:
    ldaw   r4,     sp[0];  /* SCK hack */                                                                 \
    set   sp,     r1;      /* Load sp to save location of current thread */                              \
    extsp 20;             /* make room on stack to save context */                                       \
    stw   spc,    sp[1];  /* save the saved program counter register (must be sp[1]!) */                 \
    stw   ssr,    sp[2];  /* save the saved status register (must be sp[2]!) */                          \
    stw   sed,    sp[3];  /* save the saved exception data register (must be sp[3]!) */                  \
    stw   et,     sp[4];  /* save the event type register (must be sp[4]!) */                            \
    stw   dp,     sp[5];  /* save the data pointer */                                                    \
    stw   cp,     sp[6];  /* save the constant pool pointer */                                           \
    stw   lr,     sp[7];  /* save the link register */                                                   \
    stw   r0,     sp[8];  /* save the general purpose registers r0-r11 */                                \
    stw   r1,     sp[9];                                                                                 \
    stw   r2,     sp[10];                                                                                \
    stw   r3,     sp[11];                                                                                \
    stw   r4,     sp[12];                                                                                \
    stw   r5,     sp[13];                                                                                \
    stw   r6,     sp[14];                                                                                \
    stw   r7,     sp[15];                                                                                \
    stw   r8,     sp[16];                                                                                \
    stw   r9,     sp[17];                                                                                \
    stw   r10,    sp[18];                                                                                \
    stw   r11,    sp[19];                                                                                \
    set   sp,     r0;      /* set sp to next thread (new stack pointer) */                               \
//    retsp 0                //FixMe: chk if this is reqd if we call branch
//    # Now load the destination thread by dropping through
//    # to hal_thread_load_context

    bl hal_thread_load_context //check if this needs to be called here?
.cc_bottom hal_thread_switch_context.func

// ----------------------------------------------------------------------------
//  hal_thread_load_context
//  Load thread context
//  R0 = address of sp of next thread to execute
//  Note that this function is also the second half of
//  hal_thread_switch_context and is simply dropped into from it.
.extern hal_thread_load_context
.globl hal_thread_load_context.nstackwords
.globl hal_thread_load_context.maxthreads
.globl hal_thread_load_context.maxtimers
.globl hal_thread_load_context.maxchanends
.linkset hal_thread_load_context.nstackwords, 0
.linkset hal_thread_load_context.maxthreads,  0
.linkset hal_thread_load_context.maxtimers,   0
.linkset hal_thread_load_context.maxchanends, 0

.cc_top hal_thread_load_context.func, hal_thread_load_context
.globl  hal_thread_load_context,"f{0}(ui)"
hal_thread_load_context:
    ldc   r5,   80;               /* we are going to decrement stack pointer with 20 words */            \
    sub   r0,    r0,     r5;       /* r6 holds the SP, add 80 to it */                                   \
    set   sp,    r0;              /* set the new SP */                                                   \
    ldw   spc,   sp[1];            /* restore saved program counter */                                   \
    ldw   ssr,   sp[2];            /* restore saved status register */                                   \
    ldw   sed,   sp[3];            /* restore saved exception data */                                    \
    ldw   et,    sp[4];            /* restore exception type */                                          \
    ldw   dp,    sp[5];            /* restore data pointer */                                            \
    ldw   cp,    sp[6];            /* restore constant pool pointer */                                   \
    ldw   lr,    sp[7];            /* restore link register */                                           \
    ldw   r0,    sp[8];            /* restore GP registers r0-r9 */                                      \
    ldw   r1,    sp[9];                                                                                  \
    ldw   r2,    sp[10];                                                                                 \
    ldw   r3,    sp[11];                                                                                 \
    ldw   r4,    sp[12];                                                                                 \
    ldw   r5,    sp[13];                                                                                 \
    ldw   r6,    sp[14];                                                                                 \
    ldw   r7,    sp[15];                                                                                 \
    ldw   r8,    sp[16];                                                                                 \
    ldw   r9,    sp[17];                                                                                 \
    ldw   r10,    sp[18];                                                                                \
    ldw   r11,    sp[19];                                                                                \
    set   sp,     r4;                /* SCK hack */                                                      \
    ldc   r4,     0;                 /* SCK hack */                                                      \
    retsp   0                                                                              

.cc_bottom hal_thread_load_context.func

// ----------------------------------------------------------------------------
//  restore_hal_regs
//  Load thread context
//  R0 = address of sp of next thread to execute
//  Note that this function is also the second half of
//  hal_thread_switch_context and is simply dropped into from it.
.extern restore_hal_regs
.globl restore_hal_regs.nstackwords
.globl restore_hal_regs.maxthreads
.globl restore_hal_regs.maxtimers
.globl restore_hal_regs.maxchanends
.linkset restore_hal_regs.nstackwords, 0
.linkset restore_hal_regs.maxthreads,  0
.linkset restore_hal_regs.maxtimers,   0
.linkset restore_hal_regs.maxchanends, 0

.cc_top restore_hal_regs.func, restore_hal_regs
.globl  restore_hal_regs,"f{0}()"
/* r0 and r1 are used as scratch regs */
restore_hal_regs:
    ldaw   r1,    dp[0];    /* save current DP to r1, need to restore DP when leaving function */         \
    ldw    r0,    dp[hal_saved_registers];                                                                \
    set    dp,    r0;                                                                                     \
    ldw    r2,    dp[2];                                                                                  \
    ldw    r3,    dp[3];                                                                                  \
    ldw    r4,    dp[4];                                                                                  \
    ldw    r5,    dp[5];                                                                                  \
    ldw    r6,    dp[6];                                                                                  \
    ldw    r7,    dp[7];                                                                                  \
    ldw    r8,    dp[8];                                                                                  \
    ldw    r9,    dp[9];                                                                                  \
    ldw    r10,   dp[10];                                                                                 \
    ldw    r11,   dp[11];                                                                                 \
    ldw    cp,    dp[12];                                                                                 \
    ldw    sp,    dp[14];                                                                                 \
    ldw    lr,    dp[15];                                                                                 \
    ldaw   r0,    sp[0];  /* save current SP to r0, need to restore SP after work */                      \
    ldw    sp,    dp[15]; /* on return from interrupt, KRET sets pc with spc */                           \
    ldw    spc,   sp[1];  /* hence load spc with lr of the new thread to be switched */                   \
    set    sp,    r0;     /* restore SP from r0 */                                                        \
    set    dp,    r1      /* restore DP from r1 */

.cc_bottom restore_hal_regs.func

// ----------------------------------------------------------------------------
//  save_hal_regs
//  Load thread context
//  R0 = address of sp of next thread to execute
//  Note that this function is also the second half of
//  hal_thread_switch_context and is simply dropped into from it.
.extern save_hal_regs
.globl save_hal_regs.nstackwords
.globl save_hal_regs.maxthreads
.globl save_hal_regs.maxtimers
.globl save_hal_regs.maxchanends
.linkset save_hal_regs.nstackwords, 0
.linkset save_hal_regs.maxthreads,  0
.linkset save_hal_regs.maxtimers,   0
.linkset save_hal_regs.maxchanends, 0

.cc_top save_hal_regs.func, save_hal_regs
.globl  save_hal_regs,"f{0}()"
save_hal_regs:
    ldaw   r0,    sp[0];                                                                                   \
    ldaw   r1,    dp[0];    /* save current DP to r1, need to restore DP when leaving function */          \
    ldaw   r2,    dp[hal_saved_registers];                                                                \
    set    dp,    r2;                                                                                      \
    stw    r2,    dp[2];                                                                                   \
    stw    r3,    dp[3];                                                                                   \
    stw    r4,    dp[4];                                                                                   \
    stw    r5,    dp[5];                                                                                   \
    stw    r6,    dp[6];                                                                                   \
    stw    r7,    dp[7];                                                                                   \
    stw    r8,    dp[8];                                                                                   \
    stw    r9,    dp[9];                                                                                   \
    stw    r10,   dp[10];                                                                                  \
    stw    r11,   dp[11];                                                                                  \
    stw    cp,    dp[12];                                                                                  \
    stw    sp,    dp[14];                                                                                  \
    stw    lr,    dp[15];                                                                                  \
    set    dp,    r1;    /* restore DP from r1 */                                                           \
    set    sp,    r0;   /* restore SP from r0 */

.cc_bottom save_hal_regs.func
