% XMOS Modern LaTeX class file
% Author: Douglas Watt
% Last Modified: Oct 7, 2011

\NeedsTeXFormat{LaTeX2e}[1995/12/01]
\ProvidesClass{xmosdocmodern}
              [2010/12/10 v3.0b XMOS Modern Style Class]

% Some \newif declarations are can be provided by Makefile
\ifcsname ifinternal\endcsname\else 
  \expandafter\let\csname ifinternal\expandafter\endcsname 
                  \csname iffalse\endcsname 
\fi 

\ifcsname ifcognidoxdraft\endcsname\else 
  \expandafter\let\csname ifcognidoxdraft\expandafter\endcsname 
                  \csname iffalse\endcsname 
\fi 

\ifcsname ifcognidoxissue\endcsname\else 
  \expandafter\let\csname ifcognidoxissue\expandafter\endcsname 
                  \csname iffalse\endcsname 
\fi 

\ifcsname ifconfidential\endcsname\else 
  \expandafter\let\csname ifconfidential\expandafter\endcsname 
                  \csname iffalse\endcsname 
\fi 
\ifinternal\confidentialtrue\fi

\ifcsname ifskipdisclaimer\endcsname\else
  \expandafter\let\csname ifskipdisclaimer\expandafter\endcsname
                  \csname iffalse\endcsname 
\fi 

\ifcsname ifsynapticonbranding\endcsname\else
  \expandafter\let\csname ifsynapticonbranding\expandafter\endcsname
                  \csname iffalse\endcsname 
\fi 



\ifcsname ifpublished\endcsname\else 
  \expandafter\let\csname ifpublished\expandafter\endcsname 
                  \csname iffalse\endcsname 
\fi 

\newif\ifpreliminary\preliminaryfalse
\newif\ifnochapters\nochapterstrue
\newif\ifonline\onlinetrue

\DeclareOption*{\ClassError{xmosmodern}{The `\CurrentOption' option is not supported}}

% Document base types

% Document derived types
\newif\ifdatasheet\datasheetfalse
\DeclareOption{datasheet}{\datasheettrue\documenttrue}
\DeclareOption{preliminary}{\preliminarytrue}

% Publishing options
\DeclareOption{cognidoxdraft}{\cognidoxtrue\cognidoxdrafttrue\confidentialtrue}
\DeclareOption{cognidoxissue}{\cognidoxtrue\cognidoxissuetrue\confidentialtrue}
\DeclareOption{published}{\publishedtrue}

\newif\ifarow\arowfalse
\DeclareOption{arow}{\arowtrue\onlinefalse}
\newif\ifcameraready\camerareadyfalse
\DeclareOption{a4camera}{\camerareadytrue\onlinefalse}

% Compatibility options
\newif\ifsafefont\safefontfalse
\DeclareOption{draftfont}{\safefonttrue\PassOptionsToClass{draft}{memoir}}

% Misc options (controlled by other options, fix maybe deprecate)
\DeclareOption{nochapters}{\nochapterstrue}
\newif\ifnodms\nodmsfalse
\DeclareOption{nodms}{\nodmstrue}
\DeclareOption{confidential}{\confidentialtrue}

\DeclareOption{openright}{}
\DeclareOption{10pt}{}
\DeclareOption{a4paper}{}
\DeclareOption{english}{}
\DeclareOption{twoside}{}

% Shortform option
\DeclareOption{shortform}{\shortformtrue}

% Language options
\newif\ifasian\asianfalse
\newif\ifen\entrue
\DeclareOption{en}{\entrue}
\ProcessOptions

% Determine which class and options to load
\LoadClass[oneside,onecolumn,article,9pt]{memoir}

% Set conservative values to prevent the user from needing to typeset much of a document
\widowpenalty=10000
\clubpenalty=10000
% Avoid floating figures to end of doc
\renewcommand{\textfraction}{0.01}
\renewcommand{\topfraction}{0.99}

\RequirePackage{ifpdf}

% PDF Properties
\ifpdf
\pdfminorversion=5
\pdfobjcompresslevel=0
\pdfcompresslevel=9
\fi

% Needed for internal calculations
\RequirePackage{calc}

% Set the paper stock size
\setstocksize{251.7mm}{178mm}

% Set the trimmed size
\settrimmedsize{251.7mm}{178mm}{*}
\setlength{\trimtop}{0pt}
\setlength{\trimedge}{\stockwidth}
\addtolength{\trimedge}{-\paperwidth}

% Title Width
\newlength{\titlewidth}
\setlength{\titlewidth}{135mm}

% Set the type block size
\newlength{\typeblockwidth}
\setlength{\typeblockwidth}{120mm}
\settypeblocksize{185mm}{\typeblockwidth}{*}

% Note: right margin comes first due to swap below (deprecated note)
\setlrmargins{29mm}{*}{*}
\setmarginnotes{4mm}{18mm}{\onelineskip}
%\setsecindent{-22mm}


\newlength{\blockindentlen}
\setlength{\blockindentlen}{5mm}

% Fullwidth environment
\def\@infullwidth{0}
\newlength{\textfullwidth}
\setlength{\textfullwidth}{\textwidth}
% Adjustments not quite right apparently, re-adjust based on pdflatex warning msg
\newenvironment{fullwidth}{%
\def\@infullwidth{1}
\let\sidecaption\regularfullwidthcaption\let\endsidecaption\endregularfullwidthcaption
\addtolength{\textfullwidth}{22mm-0.43306pt}%
\addtolength{\codeindent}{-22mm}
\begin{adjustwidth}{-11mm}{-11mm}%
\setlength\LTleft{-22mm}\lstset{xleftmargin=\codeindent}%
\setlength\blockindentlen{22mm}%
\setsecindent{0mm}%
}{%
\end{adjustwidth}%
\def\@infullwidth{0}
\let\sidecaption\savedsidecaption\let\endsidecaption\savedendsidecaption
\addtolength{\textfullwidth}{-22mm+0.43306pt}%
\addtolength{\codeindent}{22mm}
\setlength\LTleft{0mm}\lstset{xleftmargin=\codeindent}%
\setlength\blockindentlen{5mm}%
\setsecindent{-22mm}}

\newcommand{\fullwidthbigindent}{\hspace*{22mm}}
\newlength{\absspace}
% Tex seems to get 1.43666pt out when attempt to insert image of \paperwidth
\setlength{\absspace}{(\paperwidth-\textwidth-22mm)/2}
\newenvironment{absolutefullwidth}{\begin{adjustwidth}{-\absspace-22mm}{-\absspace-1.43666pt}}{\end{adjustwidth}}

% Indentation environment
\newlength{\savedcodeindent}
\newenvironment{indentation*}[2]%
{\begin{indentation}{#1}{#2}
 \setlength{\savedcodeindent}{\codeindent}
 \addtolength{\codeindent}{#1}
}
{\setlength{\codeindent}{\savedcodeindent}
 \end{indentation}
}

% Set UL margins
\setulmargins{2.5cm}{*}{*}
\setheadfoot{\onelineskip}{2\onelineskip}
\setheaderspaces{*}{2\onelineskip}{*}

% Finalise layout
\newlength{\manualadjust}
\setlength{\manualadjust}{32mm}
%\ifpdf\fixpdflayout\fi
\addtolength{\textheight}{60pt}
\checkandfixthelayout[lines]
\newlength{\adjustforbug}
\setlength{\adjustforbug}{-2mm}
  \ifcameraready
    % Need to base off the A4 dimensions (extra 32mm width)
	\setlength{\oddsidemargin}{\evensidemargin-32mm}   % right   FIX
  \else\ifarow
    % As above, but center in page
    \setlength{\oddsidemargin}{\evensidemargin-16mm}   % right
    \setlength{\evensidemargin}{\oddsidemargin}
	\addtolength{\topmargin}{32mm+\adjustforbug}
  \fi\fi

% CJK 
\newcommand{\cjktext}[1]{\begin{CJK}{UTF8}{}#1\end{CJK}}
\let\origbfseries\bfseries
\renewcommand{\textbf}[1]{\ifthenelse{\equal{:\current@color:}{:gray 0:}}{\textcolor{xmosblue}{\origbfseries #1}}{\origbfseries #1}}
\renewcommand{\bfseries}{\xmosblue\origbfseries}

% Part Styles
\renewcommand*{\thepart}{\Alph{part}}
\renewcommand{\partnamefont}{\hspace*{-22mm}\normalfont\Huge\sffamily\raggedright}
\renewcommand{\partnumfont}{\normalfont\Huge\sffamily}
\renewcommand{\parttitlefont}{\hspace*{-22mm}\normalfont\Huge\scshape\raggedright}
\renewcommand*{\beforepartskip}{\vspace*{97pt}} % FIX: not sure why 83pt elsewhere, possibly minipage adjustment
\renewcommand*{\afterpartskip}{\hspace*{-22mm}\rule{22mm}{0.6mm}\rule{\linewidth}{0.6mm}\\[0.5cm]}

% Chapter Styles
\RequirePackage[final]{graphicx}
\newlength{\numberheight}
\newlength{\barlength}

\makechapterstyle{veeloen}{%
\setlength{\beforechapskip}{40pt}
\setlength{\midchapskip}{25pt}
\setlength{\afterchapskip}{40pt}
\renewcommand{\chapnamefont}{\sffamily\LARGE\flushright}
\renewcommand{\chapnumfont}{\sffamily\HUGE}
\renewcommand{\chaptitlefont}{\sffamily\HUGE\bfseries\flushright}
\renewcommand{\printchaptername}{\chapnamefont\MakeUppercase{\textls[500]{\@chapapp}}}
\renewcommand{\chapternamenum}{}
\setlength{\numberheight}{16mm}
\setlength{\barlength}{\paperwidth}
\addtolength{\barlength}{-\textwidth}
\addtolength{\barlength}{-\spinemargin}
\renewcommand{\printchapternum}{%
\makebox[0pt][l]{%
%FIXed was .8 then shrunk margin
\hspace{.4em}%
\resizebox{!}{\numberheight}{\chapnumfont \thechapter}%
\hspace{.4em}%
\rule{\barlength}{\numberheight}}}
\makeoddfoot{plain}{}{}{\thepage}
}

\makechapterstyle{smallveelo}{%
\setlength{\afterchapskip}{40pt}
\renewcommand*{\chapterheadstart}{\vspace*{40pt}}
\renewcommand*{\afterchapternum}{\par\nobreak\vskip 25pt}
\renewcommand*{\chapnamefont}{\sffamily\LARGE\flushright}
\renewcommand*{\chapnumfont}{\sffamily\HUGE}
\renewcommand*{\chaptitlefont}{\sffamily\HUGE\bfseries\flushright}
\renewcommand*{\printchaptername}{%
\chapnamefont\MakeUppercase{\textls[500]{\@chapapp}}}
\renewcommand*{\chapternamenum}{}
\setlength{\beforechapskip}{18mm} % 18
\setlength{\midchapskip}{\paperwidth}
\addtolength{\midchapskip}{-\textwidth}
\addtolength{\midchapskip}{-\spinemargin}
\renewcommand*{\printchapternum}{%
  \makebox[0pt][l]{\hspace{.8em}%
  \resizebox{15mm}{!}{\chapnumfont \thechapter}%
  \hspace{.8em}%
  \rule{\midchapskip}{\beforechapskip}%
}}%
}

\makechapterstyle{collection}{%
\setlength{\afterchapskip}{0pt}
\setlength{\beforechapskip}{6.2mm}
\setlength{\midchapskip}{\textwidth}
\addtolength{\midchapskip}{-\beforechapskip+22mm}
\renewcommand*{\chapterheadstart}{\vspace*{0pt}} % Note that 1.4cm brings to top, but need to reduce 1.4 to account for pubfooter in single document
\renewcommand*{\chaptitlefont}{\titlefont}
\renewcommand*{\chapnumfont}{\chaptitlefont}
\renewcommand*{\printchaptername}{}
\renewcommand*{\chapternamenum}{}
\renewcommand*{\afterchapternum}{}
\renewcommand*{\printchapternum}{}
\renewcommand*{\printchaptertitle}[1]{\thispagestyle{noheader}\begin{fullwidth}%
\begin{minipage}[t]{\beforechapskip}{\chapnumfont\thechapter}\end{minipage}%
\hfill\begin{minipage}[t]{\midchapskip}{\chaptitlefont ##1\par}\end{minipage}%
\\\rule{\linewidth}{1.0mm}\end{fullwidth}}}
\renewcommand*{\afterchaptertitle}{}

% Set chapter and section styles/number depth
\chapterstyle{collection}

\usepackage{xcolor}
\definecolor{xmosblue}{rgb}{0.0745, 0.6, 0.8588} 
\definecolor{xmosgreen}{rgb}{0.6, 0.8549, 0.02745} 
\definecolor{xmoslightgrey}{rgb}{0.8196, 0.82745, 0.83137} 
\definecolor{xmosdarkgrey}{rgb}{0.274, 0.278, 0.290} 
\def\xmosblue{\color{xmosblue}}
\def\xmosgreen{\color{xmosgreen}}
\def\xmoslightgrey{\color{xmoslightgrey}}
\def\xmosdarkgrey{\color{xmosdarkgrey}}

% Disable chapters if flagged with \nochapters
\ifnochapters
\renewcommand*\thesection{\arabic{section}}
\fi

\newcommand{\MoreThanNineChapters}{\chapterstyle{smallveelo}}
\newcommand{\FourDigitsInTocSection}{\setlength{\cftsectionnumwidth}{1.05cm}}

% FIX - just put this into `inthisdocument'
\newlength{\boxwidth}

\newcommand{\warnmessage}[1]{%
\setlength{\boxwidth}{\textwidth}%
\addtolength{\boxwidth}{-2\fboxsep}%
\addtolength{\boxwidth}{-2\fboxrule}%
\addtolength{\boxwidth}{-4mm}%
\hspace*{-22mm}\fcolorbox{black}{darkred}{\begin{minipage}[t]{18mm}\vspace{0pt}\hfill\includegraphics{dangermargin}\end{minipage}%
\hspace*{4mm}\begin{minipage}[t]{\boxwidth}\vspace{0pt}\color{white}{#1\\\vspace*{-4pt}}\end{minipage}\hspace*{4mm}}}

\newcommand{\infomessage}[1]{%
\setlength{\boxwidth}{\textwidth}%
\addtolength{\boxwidth}{-2\fboxsep}%
\addtolength{\boxwidth}{-2\fboxrule}%
\addtolength{\boxwidth}{-4mm}%
\hspace*{-22mm}\fcolorbox{black}{darkblue}{\begin{minipage}[t]{18mm}\vspace{0pt}\hfill\includegraphics{notifymargin}\end{minipage}%
\hspace*{4mm}\begin{minipage}[t]{\boxwidth}\vspace{0pt}\hypersetup{linkcolor=white, urlcolor=white}\color{white}{#1\\\vspace*{-4pt}}\end{minipage}\hspace*{4mm}}}

\newcommand{\betachapter}{\renewcommand*{\chapterheadstart}{%
\setlength{\boxwidth}{\textwidth}%
\addtolength{\boxwidth}{-2\fboxsep}%
\addtolength{\boxwidth}{-2\fboxrule}%
\addtolength{\boxwidth}{-4mm}%
\hspace*{-22mm}\fcolorbox{black}{xmosyellow}{\begin{minipage}[t]{18mm}\vspace{0pt}\hfill\includegraphics{dangermargin}\end{minipage}%
\hspace*{4mm}\begin{minipage}[t]{\boxwidth}\vspace{0pt}\color{black}{\small %
The features documented in this chapter are made available in beta form and are therefore subject to change without notice.\\\vspace*{-4pt}}\end{minipage}\hspace*{4mm}}\\[80pt]}}
\newcommand{\nobeta}{\renewcommand*{\chapterheadstart}{\vspace*{93pt}}}

% Number section depth up to X.Y.Z (for books this gives C.X.Y.Z)
\maxsecnumdepth{subsubsection}

% Footnote styles
\newfootnoteseries{P}
\renewcommand*{\@makefnmarkP}[1]{\slashfracstyle{(X #1)}}
\footmarkstyleP{#1--}

\setlength{\footmarkwidth}{1.8em}
\setlength{\footmarksep}{0em}
\footmarkstyleP{\MakeUppercase{#1}.\hfill}

% For documents, put footnotes in wide margin
\renewcommand*{\footnoterule}{\vspace*{\fill}\hspace*{-22mm}\rule{35mm}{0.2mm}\\[-0.8em]}
\setlength{\footmarkwidth}{0mm}
\setlength{\footmarksep}{-22mm}
\footmarkstyle{\hspace*{-22mm}\textsuperscript{#1}}
%\footmarkstyle{\hspace*{-22mm}\hfill\textsuperscript{#1}} FIXED
\feetbelowfloat

% Indexing
\makeindex

%\RequirePackage[OriginalCommands]{ragged2e}

\RequirePackage{amsmath}
\RequirePackage[cleanup={}]{pstool} % for generating custom eps to pdf graphics for datasheets, can add mode=nonstop,cleanup={} for debug (.tex, .dvi, .ps, .pdf, .log, .aux)
\ifpdf
\RequirePackage[activate={true,nocompatibility},final]{microtype}
% Prevent \texttt{--} from becoming em-dash
\DisableLigatures{encoding = T1, family = tt*} 
\fi
\RequirePackage{stmaryrd}
\RequirePackage{alltt}
\RequirePackage{amsfonts}
\RequirePackage{setspace}
\RequirePackage{multicol}
\RequirePackage{tabularx}
\renewcommand{\tabularxcolumn}[1]{b{#1}}
\RequirePackage{ifthen}
\RequirePackage{longtable} 
%\setlength{\LTpost}{-1em}
\newcolumntype{Y}{>{\raggedright\arraybackslash}X}
\newcolumntype{y}{>{\small\raggedright\arraybackslash}X}
\RequirePackage{textcomp}
\RequirePackage{url}
\RequirePackage{listings}
\RequirePackage{gensymb}
\RequirePackage{manfnt}
\RequirePackage{pifont}
\RequirePackage{xspace}
\RequirePackage{multirow}
\RequirePackage{colortbl}
\RequirePackage{varioref}
\RequirePackage{chngcntr}
\RequirePackage{booktabs}
\RequirePackage{enumitem}
%\RequirePackage{quoting} \quotingsetup{vskip=0pt}
\RequirePackage{placeins} % defines \FloatBarrier command
\RequirePackage{flafter} % floats come after reference
%\RequirePackage[NewCommands]{ragged2e}
\RequirePackage{float}
\RequirePackage{marginnote} % works properly with \reversemarginpar to always use left margins 
\RequirePackage{layouts} % only to debug, for printing lengths
\RequirePackage{units}

% Load the required symbols
\RequirePackage{savesym}
\RequirePackage{marvosym}
\savesymbol{Cross} % conflict between marvosym and bbding
\savesymbol{checkmark} % conflict between dingbat and AMS
\RequirePackage{bbding}
\RequirePackage{dingbat}

% Localisation

% PDF Settings (must load after other packages)
\ifonline
\ifasian
\RequirePackage[hyperindex=false,hyperfootnotes=false,bookmarks=true]{hyperref}
\else
\RequirePackage[hyperindex=true,hyperfootnotes=false,bookmarks=true]{hyperref}
\fi
\hypersetup{%
  %pdfkeywords        = {Event-driven processor, RELEASE:1,18mm,33mm,"Publication Date: \$DATE", RELEASE:1,XXX,YYY,"\$YEAR Xmos Ltd. All Rights Reserved.", RELEASE:L,XXX,YYY,"\$YEAR by Xmos Limited."},
  pdfcreator         = {\LaTeX},
  pdfpagemode        = UseOutlines,
  pdfdisplaydoctitle = true,
  pdfstartview       = Fit,
  baseurl            = {http://www.xmos.com/},
  pdfpagelayout      = SinglePage,
  breaklinks
}
\newcommand{\pdfMakeTitle}{\hypersetup{pdftitle={\atTheTitle}}}
\newcommand{\pdfPartTitle}{\hypersetup{pdfparttitle={\atPartTitle}}}
\newcommand{\pdfMakeAuthor}{\hypersetup{pdfauthor={\ifx\@author\@empty Xmos Ltd.\else\@author\fi}}}
\RequirePackage{memhfixc}
\hypersetup{pdfproducer = {XMOS Modern LaTeX Class File (Version 2.0)}}
\hypersetup{colorlinks = true, linkcolor = xmosblue, citecolor = xmosblue, urlcolor = xmosblue }
\fi

% PDF named sections
\newcommand{\pdfsection}[2]{\section[#1]{\hyperdef{sectionname}{#2}{#1}}}
\newcommand{\pdfsubsection}[2]{\subsection[#1]{\hyperdef{sectionname}{#2}{#1}}}
\newcommand{\pdfsubsectiontwo}[3]{\subsection[#1]{\hyperdef{sectionname}{#2}{#1}\hyperdef{sectionname}{#3}{}}}
\newcommand{\pdfsubsectionthree}[4]{\subsection[#1]{\hyperdef{sectionname}{#2}{#1}\hyperdef{sectionname}{#3}{}\hyperdef{sectionname}{#4}{}}}

% Title Page
%\def\and{\\[0.5em]}
\def\and{, }
\renewcommand{\title}[1]{\def\atTheTitle{#1}\def\@pdfTitle{#1}} \title{}
\newcommand{\parttitle}[1]{\def\atPartTitle{#1}\def\@pdfPartTitle{#1}} \parttitle{}
\ifen\else
\newcommand{\entitle}[1]{\def\atEnTitle{#1}} \entitle{}
\fi
\renewcommand{\author}[1]{\def\@author{#1}\def\theAuthor{#1}} \author{}
\newcommand{\translator}[1]{\def\atTheTranslator{#1}} \translator{}
\newcommand{\yearmonthday}[3]{\def\atTheYear{#1}\def\atTheDate{#1/#2/#3}} \yearmonthday{\number\year}{\number\month}{\number\day}
\newcommand{\xmospart}[1]{\def\thexmospart{#1}}
\newcommand{\auth}[2]{{#1\ }{\uppercase{#2}}}
\newcommand{\authx}[3]{{#1\ }{#2#3}} % Depricate
\newcommand{\inprint}[1]{\def\@theBookInPrint{#1}} \inprint{}
\newcommand{\inen}[1]{\def\@theBookInEN{#1}} \inen{}
\newcommand{\intw}[1]{\def\@theBookInTW{#1}} \intw{}
\newcommand{\inzh}[1]{\def\@theBookInZH{#1}} \inzh{}
\newcommand{\injp}[1]{\def\@theBookInJP{#1}} \injp{}
\newcommand{\inkr}[1]{\def\@theBookInKR{#1}} \inkr{}
\newcommand{\notes}[1]{\def\atTheNotes{#1}} \notes{}

% Start/Finish (Controls CJK/Disclaimer)
\newcommand{\AddedMyOwnDisclaimer}{\def\@disclaim{1}}

%% English fix
\ifen
\newcommand{\start}{\begin{document}\AddToShipoutPicture*{\BackgroundPic}\ifdefined\makedocnum\makedocnum\fi}
\newcommand{\valuedcustomer}{\input{valued_en}}
\AtEndDocument{\ifdefined\@disclaim\else
	  \ifthenelse{\value{lastsheet}>1}{\makepubpage}{}
\fi
% Following command required by old datasheet generator only
% \ifthenelse{\value{revcounter}=0}{}{\def\revisionerror{1}}\ifdefined\revisionerror\ClassError{xmosmodern}{The revision for the latest document is incorrect}\fi
}
\fi

% This interferes with pstool, which redefines document
\ifdefined\@notinpstool
\AtEndDocument{\ifdefined\@disclaim\else\makepubpage\fi}
\fi

% Note: This must be included after AtEndDocument
\RequirePackage{lastpage}

% Publisher Page

\newcounter{sheetsavedcounter}
\newlength{\ppagespace}
\setlength{\ppagespace}{1.5em}
\newcommand{\by}{\emph{by}}

\newcommand{\preparefooterpub}{\enlargethispage{-1.4cm}}
\newcommand{\makefooterpub}{%
\ifthenelse{\equal{\value{lastsheet}}{1}}{\vspace*{-1.3cm}}{\vspace*{-0.83cm}}
\begin{minipage}{\linewidth}
%


\ifskipdisclaimer
\else
\ifthenelse{\equal{\value{lastsheet}}{1}}{\vspace*{0.1cm}\footnotesize \licenseeTrademark}{}%
\vspace{7mm}\hspace*{\fill}{\includegraphics{\xmoslogo}}
\fi
\end{minipage}
}

\newcommand{\makepubpage}{
\def\@disclaim{1}
\footnotesize
\flushbottom
  % Use trick to get to bottom of current or next page (if \needspace creates a short page it makes it flushbottom)
  \FloatBarrier % ensure all figures printed by this time
  \setcounter{sheetsavedcounter}{\value{sheetsequence}}
  \Needspace{3.3cm}
  %\ifthenelse{\equal{\value{sheetsavedcounter}}{\value{sheetsequence}}}{}{\vspace*{\fill}\begin{fullwidth}\centering\normalsize This Page Intentionally Left Blank\end{fullwidth}}
  \vspace*{\fill}
  \small
  \begin{fullwidth}
  \enlargethispage{\baselineskip}
  \includegraphics{\xmoslogo}\\[0.5em]
  \companyextra\\[0.5em]
  Copyright \copyright\ \ifx\atTheYear\@empty\number\year\else\atTheYear\fi, All Rights Reserved.

  {\xmoslightgrey\rule[1mm]{\linewidth}{0.5pt}}
  \licenseeTrademark
  \vspace*{-1.5mm}
  \end{fullwidth}
}

% Copyright Symbol (needed for languages without (C) symbol)
%\newcommand{\xcpy}{\ifasian{{\setmainfont{Lucida Bright}\copyright}}\else\copyright\fi}

\def\@translated{}
\def\atDatasheetHeadline{}

\newcommand{\testforrevdata}{\ifdefined\atDocumentRevision\def\atanyversiondata{1}\fi\ifx\theVersion\@empty\else\def\atanyversiondata{1}\fi\ifcognidoxdraft\def\atanyversiondata{1}\fi\ifcognidoxissue\def\atanyversiondata{1}\fi}
\newcommand{\testfordocdata}{\ifdefined\atDocumentNumber\def\atanydocdata{1}\fi\testforrevdata\ifdefined\atanyversiondata\def\atanydocdata{1}\fi}

\newcommand{\PrintDocumentRevision}{\ifcognidoxdraft\PrintDraft\else\ifcognidoxissue\PrintIssue\else\ifpublished\PrintPublished\else\ifx\theVersion\@empty\else REV \theVersion\fi\fi\fi\fi}
\newcommand{\PrintDocumentRevisionNoDate}{\ifcognidoxdraft\PrintDraftNoDate\else\ifcognidoxissue\PrintIssueNoDate\else\ifpublished\PrintPublished\else\ifx\theVersion\@empty\else REV \theVersion\fi\fi\fi\fi}

\newcommand{\PrintDraft}{DRAFT \ifdefined\atDocumentRevision\atDocumentRevision\else\ifx\theVersion\@empty\atTheDate\else\theVersion\fi\fi}
\newcommand{\PrintDraftNoDate}{DRAFT \ifdefined\atDocumentRevision\atDocumentRevision\else\ifx\theVersion\@empty NOT IN DMS\else\theVersion\fi\fi}

\newcommand{\PrintIssue}{\ifdefined\atDocumentRevision ISSUE \atDocumentRevision\else\ifx\theVersion\@empty ISSUED \atTheDate\else ISSUE \theVersion\fi\fi}
\newcommand{\PrintIssueNoDate}{\ifdefined\atDocumentRevision ISSUE \atDocumentRevision\else\ifx\theVersion\@empty ISSUE NOT IN DMS\else ISSUE \theVersion\fi\fi}

\newcommand{\PrintPublished}{\ifdefined\atDocumentRevision\ifdefined\atDocumentNumber\ v\atDocumentRevision\else REV \atDocumentRevision\fi\fi}

\def\PrintDocNum{
  \ifcognidoxdraft\color{brightred}\fi
  \ifdefined\atDocumentNumber 
    \ifcognidoxdraft 
	  XMOS Part Number%
	\else\ifcognidoxissue 
	  XMOS Part Number%
	\else 
	  Document Number%
	\fi\fi:\,%
	\atDocumentNumber
  \fi
  \testforrevdata
  \ifdefined\atanyversiondata\ifdefined\atDocumentNumber\ifpublished\else, \fi\PrintDocumentRevisionNoDate\else\PrintDocumentRevisionNoDate\fi\fi
  \color{black}}

\def\PrintShortDocNum{
  \ifcognidoxdraft\color{brightred}\fi
  \ifdefined\atDocumentNumber 
	\atDocumentNumber
  \fi
  \testforrevdata
  \ifdefined\atanyversiondata\ifdefined\atDocumentNumber\ifpublished\else, \fi\PrintDocumentRevision\else\PrintDocumentRevision\fi\fi
  \color{black}}

 
% FIX deleted as no longer required - remove
\RequirePackage{afterpage}

\newcommand{\titlefont}[1]{\huge\sffamily#1}
\newcommand{\Titlefont}[1]{\Huge\sffamily#1}
\newcommand{\Authorfont}[1]{\huge\sffamily#1}

\newcommand{\pubdate}{%
\ifcognidoxdraft
\textsf{Draft Date: \atTheDate}
\else\ifcognidoxissue
\textsf{Issue Date: \atTheDate}
\else\ifpublished
\textsf{Publication Date: \atTheDate}
\else
\textsf{\atTheDate}
\fi\fi\fi}

\renewcommand{\maketitle}{ 
  \ifshortform
    \begin{fullwidth}
      \pdfMakeTitle\pdfMakeAuthor\makeDMSHook
      \hspace*{\fill}{\includegraphics{\xmoslogo}}
      \\[7mm]
      \parindent=0mm
      \parskip=3mm
      \noindent{\titlefont{\atTheTitle}}\\\vspace*{1mm}{\xmosblue\rule{2.5cm}{2mm}}
      \\[1mm]\pubdate\\[0.1cm]
      \PrintDocNum\\[0.1cm]
    \end{fullwidth}
  \else
    \AddToShipoutPicture*{\BackgroundPic}\ifdefined\makedocnum\makedocnum\fi
    \calccentering{\unitlength}
    \pdfMakeTitle\pdfMakeAuthor\makeDMSHook
    \preparefooterpub
    \thispagestyle{footerpub}
    \parindent=0mm
    \parskip=3mm
    \begin{fullwidth}
    \noindent\\[15.5cm]{\titlefont{\atTheTitle}}\\\vspace*{1mm}{\xmosblue\rule{2.5cm}{2mm}}
    \\[1mm]\pubdate\\[0.1cm]
    \PrintDocNum\\[0.1cm]
    \end{fullwidth}
    \newpage
    \def\@notinpstool{}
  \fi
  \begin{inthisdocumenttwo}
    \renewcommand{\printtoctitle}[1]{}
    \renewcommand*{\cftsubsectionfont}{\footnotesize}
    \renewcommand*{\cftsubsectionpagefont}{\footnotesize}
    \renewcommand*{\cftsubsectionname}{~~~}
    \renewcommand*{\cftsubsubsectionfont}{\scriptsize}
    \renewcommand*{\cftsubsubsectionpagefont}{\scriptsize}
    \renewcommand*{\cftsubsubsectionname}{~~~~~~~~~~~~}
    
    \setcounter{tocdepth}{\thepreferredtocdepth}
    \tableofcontents*
  \end{inthisdocumenttwo}
}

% Documents have docnums in DMS; also provide location to stamp publication information
\newcommand{\makeDMSHook}{\hypersetup{pdfkeywords={\ifdefined\atDocumentNumber DOCNUM:\atDocumentNumber\ifdefined\atDocumentRevision\atDocumentRevision\fi\fi,FOOTER:10,62,25;RELEASE:1,10,61,104,Publication Date: \$DATE;}}}

% Fonts and Paragraph
% See localiastion files for non-English font/paragraph settings
\ifonline\ifen\renewcommand*\familydefault{\sfdefault}\fi\fi
\def\Small{\fontsize{8pt}{9pt}\selectfont} % This is intended for lstlistings
\def\Smaller{\fontsize{7.5pt}{8.5pt}\selectfont} % This is intended for lstlistings
\def\Scriptsize{\fontsize{6pt}{6pt}\selectfont}
\def\Tiny{\fontsize{4pt}{4pt}\selectfont}
\def\TINY{\fontsize{3pt}{3.5pt}\selectfont}

\ifen
\usepackage[sfdefault,light]{roboto}
\RequirePackage{fontenc}
\usepackage{eso-pic}
\newcommand\BackgroundPic{%
\put(0,0){%
\parbox[b][\paperheight]{\paperwidth}{%
\vfill
\centering
\includegraphics[width=\paperwidth,height=\paperheight,%
keepaspectratio]{striking-image.jpg}%
\vfill
}}}
\usepackage{roboto-mono}
\newlength{\cloverleafheight}
\newcommand{\CloverLeaf}{\settoheight\cloverleafheight{\textsf{]}}\includegraphics[height=\cloverleafheight]{cloverleaf.pdf}\xspace}
\ifonline
\nonzeroparskip
\parindent=0mm
\fi
\else
\RequirePackage{fontspec,xunicode,xltxtra}
\RequirePackage{xCJK}
%\RequirePackage{CJKpunct}
%\punctstyle{plain}
\XeTeXinputencoding "bytes"
\XeTeXdefaultencoding "bytes"
\fi
%\fi

% Must call package after setting fonts - changes single quotes 
% to straight line in verbatim/verb environments, as expected 
% for program listings
\RequirePackage{upquote}

% Chapter/section style
\setsecheadstyle{\LARGE\bfseries\raggedright}
\setsubsecheadstyle{\large\bfseries\raggedright}
\setsubsubsecheadstyle{\bfseries\raggedright}
% Shrink the spacing a little
\setbeforesecskip{-1ex plus -1ex minus -.2ex}
\setaftersecskip{1.0\onelineskip plus .2ex}
\setbeforesubsecskip{1.0\onelineskip plus -1ex minus -.2ex}
\setaftersubsecskip{1.0\onelineskip plus .2ex}

\ifdatasheet
% Make space between section title and first line of paragraph fixed (not rubber) 
% so that we can relocated text there for small headings
\newlength{\fixedsecskip}
\setlength{\fixedsecskip}{\onelineskip-0.7mm}
\setaftersecskip{\fixedsecskip}
\newcommand{\narrowsecname}{\vspace*{-8.7mm}}
\fi

% Figures
% Remove spacing between in-text figures
\setlength{\intextsep}{\baselineskip}
\setlength{\textfloatsep}{3\baselineskip}

% FIX DO THESE FOR FULLWIDTH
%\belowcaptionskip
%\abovecaptionskip

% Header and Footer

\def\vhrulefill#1{\leavevmode\leaders\hrule\@height#1\hfill \kern\z@}

\newlength{\xmoslogolength}       % whole logo
\def\xmoslogo{xmos-logo-2020}
\setlength{\xmoslogolength}{50mm}

\newlength{\xmoslogoXheight}      % Just a single X
\def\xmoslogoX{x-logo}
\setlength{\xmoslogoXheight}{6.9mm}

\setlength{\headwidth}{\textwidth}

\newlength{\footernologolength}
\newlength{\footerpartlinelength}
\setlength{\footernologolength}{\headwidth}
\addtolength{\footernologolength}{-\xmoslogolength}
\setlength{\footerpartlinelength}{\footernologolength/2}

% Single Page (document) layout
\makepagestyle{singlepage}
\makerunningwidth{singlepage}{\headwidth}
%\makeheadrule{singlepage}{\headwidth}{1.2pt}
\makeheadposition{singlepage}{flushright}{flushright}{flushrught}{flushright}
\makepsmarks{singlepage}{%
 \nouppercaseheads
 \createmark{chapter}{both}{nonumber}{}{}
 \createmark{section}{right}{shownumber}{}{\quad}
 \createplainmark{toc}{both}{\contentsname}
 \createplainmark{lof}{both}{\listfigurename}
 \createplainmark{lot}{both}{\listtablename}
 \createplainmark{bib}{both}{\bibname}
 \createplainmark{index}{both}{\indexname}
 \createplainmark{glossary}{both}{\glossaryname}
} 
\newcommand{\headerfont}[1]{{\xmosdarkgrey #1}}
\newcommand{\footerfont}[1]{{\xmosdarkgrey #1}}
\setlength\headheight{29pt}
\setlength\headsep{0pt}

\makeoddhead{singlepage}{\hfill\headerfont{\ifx\atTheTitle\@empty\else\atTheTitle\fi%
    \ifdefined\atToolsVersionNumber\ \emph{for tools version%
      \atToolsVersionNumber}\fi}%
  \\{\xmoslightgrey\rule[5mm]{\headwidth}{0.5pt}}%
  }{}{} 

\newcommand{\companyextra}{
\ifsynapticonbranding\hfill IN PARTNERSHIP WITH \hspace{-1mm} $\vcenter{\hbox{\includegraphics{synapticon-logo}}}$\fi}
\newcommand{\footerpubsummary}{\raggedright\footerfont{\testfordocdata
 \thepage \hfill\ \raisebox{-2.5mm}{\includegraphics[height=\xmoslogoXheight]{\xmoslogoX}}}}
\makeoddfoot{singlepage}{}{\mbox{}\\[\onelineskip]{\xmoslightgrey\rule[2mm]{\headwidth}{0.5pt}}%
\ifpreliminary%
\begin{picture}(0,0)\put(11,0){\makebox(0,0)[bl]{\includegraphics[width=\textwidth]{preliminary}}}\end{picture}%
\fi%
\\\footerpubsummary\companyextra}{}

% Special page header/footers
\makepagestyle{frontpage}
\makerunningwidth{frontpage}{\headwidth}
\makeheadposition{frontpage}{flushright}{flushright}{flushrught}{flushright}
\makeoddfoot{frontpage}{}{\mbox{}\\[\onelineskip]\rule[2mm]{\footerpartlinelength}{1.2pt}\includegraphics{\xmoslogo}\rule[2mm]{\footerpartlinelength}{1.2pt}\companyextra}{}

\makepagestyle{noheader}
\makerunningwidth{noheader}{\headwidth}
\makeheadposition{noheader}{flushright}{flushright}{flushrught}{flushright}
\makeoddfoot{noheader}{}{\mbox{}\\\vspace*{-0.8em}\footerpubsummary\companyextra}{}

\makepagestyle{footerpub}
\makerunningwidth{footerpub}{\headwidth}
\makeheadposition{footerpub}{flushright}{flushright}{flushrught}{flushright}
\makeoddfoot{footerpub}{}{\makefooterpub}{}

%\mbox{}\\[\onelineskip]{\xmoslightgrey\rule[2mm]{\headwidth}{0.5pt}}
\copypagestyle{nofooter}{singlepage}
\makeoddfoot{nofooter}{}{}{}

% Double Page (book) layout
\makepagestyle{doublepage}
\makerunningwidth{doublepage}{\headwidth}
\makeheadrule{doublepage}{\headwidth}{\normalrulethickness}
\makeheadposition{doublepage}{flushright}{flushleft}{}{}
\makepsmarks{doublepage}{%
\nouppercaseheads
 \createmark{chapter}{both}{nonumber}{}{}
 \createmark{section}{right}{shownumber}{}{\quad}
 \createplainmark{toc}{both}{\contentsname}
 \createplainmark{lof}{both}{\listfigurename}
 \createplainmark{lot}{both}{\listtablename}
 \createplainmark{bib}{both}{\bibname}
 \createplainmark{index}{both}{\indexname}
 \createplainmark{glossary}{both}{\glossaryname}
}
\makeevenhead{doublepage}{\textsf{\headerfont{\thepage}}}{}{\headerfont{\leftmark}}
\makeoddhead {doublepage}{\textsf{\headerfont{\rightmark}}}{}{\headerfont{\thepage}}

\ifonline
% fix: why isn't empty cutting it here?
\copypagestyle{plain}{singlepage}
\makeheadrule{plain}{\headwidth}{0pt}
\makeoddhead{plain}{}{}{}
\else
\makeevenfoot{plain}{}{}{}
\makeoddfoot{plain}{}{}{}
\fi

\copypagestyle{normal}{singlepage}
\copypagestyle{plain}{singlepage}

\pagestyle{singlepage}

% Double Page Clear
\newcommand{\clearemptydoublepage}{\newpage{\thispagestyle{plain}\cleardoublepage}}
%\let\origdoublepage\cleardoublepage
%\newcommand{\clearemptydoublepage}{%
%\clearpage%
%\ifonline\else{\pagestyle{empty}\origdoublepage}\fi%
%}

% Table of Contents Settings
\newcommand{\toc}{{\parskip=0mm\begin{fullwidth}\tableofcontents*\end{fullwidth}}}
\newcommand{\tocValued}{\toc\vspace\fill\AddedMyOwnDisclaimer\valuedcustomer\newpage}
\renewcommand{\tocheadstart}{}
\renewcommand{\contentsname}{Table of Contents}
\renewcommand{\printtoctitle}[1]{\LARGE\bfseries #1}
\renewcommand{\afterchaptertitle}{\vskip\onelineskip}
\renewcommand{\aftertoctitle}{\thispagestyle{singlepage}\afterchaptertitle}

% Forced Indentation
\newlength\forceindentlen
\setlength\forceindentlen{18pt}
\ifonline
\newcommand{\forceindent}{\forceindentlen}
\else
\newcommand{\forceindent}{\indent}
\fi
\newcommand{\forcelargeindent}{\forceindent\forceindent\forceindent}

% Program Environment - fix del
%\floatstyle{ruled}
%\newfloat{program}{thp}{lop}
%\floatname{program}{Program}

% Commentary Environment
\newenvironment{commentary}{\begin{adjustwidth}{11mm}{}\begin{small}}{\end{small}\end{adjustwidth}}

% Hline
\newlength\savedwidth
\newcommand\Hline{\noalign{\global\savedwidth\arrayrulewidth\global\arrayrulewidth 1.8pt}\hline\noalign{\global\arrayrulewidth\savedwidth}}

% Named lists
\newenvironment{Ventry}[1]%
{\begin{list}{}{\renewcommand{\makelabel}[1]{\textbf{##1}\hfil}%
\settowidth{\labelwidth}{\textbf{#1}}%
\setlength{\leftmargin}{\labelwidth + \labelsep}}}%
{\end{list}}

\definecolor{arrowcolor}{gray}{0.6}
\definecolor{arrowtextcolor}{gray}{0.45}

\newlist{steps}{enumerate}{1}
\setlist[steps]{leftmargin=*, labelindent=\parindent, topsep=0pt, partopsep=0pt, parsep=\parskip-0.5em, itemsep=0.5em, label=\arabic*.}

\newlist{compactsteps}{enumerate}{1}
\setlist[compactsteps]{leftmargin=*, labelindent=\parindent, topsep=0pt, partopsep=0pt, parsep=\parskip-0.5em, itemsep=0pt, label=\arabic*.}

\newlist{points}{itemize}{1}
\setlist[points]{leftmargin=*, labelindent=\parindent, topsep=0pt, partopsep=0pt, parsep=\parskip-0.5em, itemsep=0.5em, label=\color{arrowcolor}{\Forward}}

\newlist{compactpoints}{itemize}{1}
\setlist[compactpoints]{leftmargin=*, labelindent=\parindent, topsep=0pt, partopsep=0pt, parsep=\parskip-0.5em, itemsep=0pt, label=\color{arrowcolor}{\Forward}}

\newlist{nopoints}{itemize}{1}
\setlist[nopoints]{leftmargin=0pt, labelindent=0pt, topsep=0pt, partopsep=0pt, parsep=\parskip, itemsep=0pt, label=}

\newlist{compactnopoints}{itemize}{1}
\setlist[compactnopoints]{leftmargin=0pt, labelindent=0pt, topsep=0pt, partopsep=0pt, parsep=0pt, itemsep=0pt, label=}

\newlist{actions}{itemize}{1}
\setlist[actions]{leftmargin=*, labelindent=\parindent, topsep=0pt, partopsep=0pt, parsep=\parskip-0.5em, itemsep=0.5em, label=\Forward}

% List of functions (fix, not used by RST so may wish to remove)
\newlist{functions}{itemize}{1}
\setlist[functions]{leftmargin=*, labelindent=\parindent, topsep=0pt, itemsep=1em, label=\Forward}
\newcommand{\func}[1]{\begin{sloppypar}\texttt{\textbf{#1}}\end{sloppypar}\nopagebreak}

% List of Functions in full width environment (fix, not used by RST so may wish to remove)
\newlist{fullwidthfunctions}{description}{1}
\setlist[fullwidthfunctions]{leftmargin=22mm, topsep=0pt, partopsep=0pt, itemsep=0.5\baselineskip, style=nextline, parsep=0.5\baselineskip, font=\ttfamily\sloppy}

% Features List
\newlist{features}{itemize}{3}
\setlist[features]{leftmargin=*, label=\Forward, topsep=0pt, itemsep=0.2em, partopsep=0pt}
\setlist[features,1]{font=\bfseries}
\setlist[features,2]{label=\color{arrowcolor}{\textbullet}, itemsep=0em, topsep=-0.15em, beginpenalty=1000, midpenalty=1000}
\setlist[features,3]{label={---}, itemsep=0em, beginpenalty=10000, midpenalty=10000}

\newlist{revisions}{enumerate}{2}
\setlist[revisions,1]{leftmargin=*, labelindent=0mm, itemsep=2em, font=\bfseries, label=Rev.}
\setlist[revisions,2]{leftmargin=3mm, labelindent=\parindent, label=\arabic*., beginpenalty=1000, midpenalty=1000}

% Unix-style Options 
\newlist{option}{description}{1}
\setlist[option]{font=\ttfamily, leftmargin=22mm, itemsep=0.5\baselineskip, parsep=0.5\baselineskip, style=nextline}
\newcommand{\duplicateoption}{\vspace*{-\baselineskip}} % fix, may not be robust between page breaks
\newcommand{\optemph}[1]{\textmd{\sffamily\textit{#1}}}
\newcommand{\optind}{\hspace{35pt}} % fix, may be redundant now

% Defaults for Documents (as above)
\renewlist{description}{description}{99}
\setlist[description]{leftmargin=*, style=nextline}
\renewlist{itemize}{itemize}{99}
\setlist[itemize]{leftmargin=*, labelindent=\parindent, topsep=0pt, partopsep=0pt, parsep=\parskip-0.5em, itemsep=0.5em, label=\color{arrowcolor}{\Forward}} % As per Points
\renewlist{enumerate}{enumerate}{99}
\setlist[enumerate]{leftmargin=*, labelindent=\parindent, topsep=0pt, partopsep=0pt, parsep=\parskip-0.5em, itemsep=0.5em,label=\arabic*.}

\newenvironment{block-itemize}{%
  \itemize
  \let\my@olditem\item
  \let\my@closepage\relax  
  \def\item{%
    \my@closepage\my@olditem\minipage[t]{\textwidth}%
    \let\my@closepage\endminipage
  }%
}{\my@closepage\enditemize}


% Fancy layout for 'In this document'

\newlist{arrow}{itemize}{1}
\setlist[arrow]{leftmargin=*, label=\color{arrowcolor}{\Forward}, topsep=0pt, itemsep=0.4em, partopsep=0pt}

\newlength{\inthisdocumentbot}
\setlength{\inthisdocumentbot}{-\onelineskip+0.4em}
\newlength{\inthisdocumentskip}
\setlength{\inthisdocumentskip}{0.5em}
\newenvironment{inthisdocument}%
  {\begin{fullwidth}
  \hypersetup{linkcolor=arrowtextcolor}
  \vspace*{-1.3em}\noindent\color{arrowtextcolor}\small{\textsf{IN THIS DOCUMENT}}
  \vspace*{-0.5em}
  \begin{arrow}}%
  {\end{arrow}\vspace*{\inthisdocumentbot}
  {\color{arrowcolor}{\rule{\linewidth}{0.06cm}}}\\[\inthisdocumentskip]
  \end{fullwidth}
  \par}

\newenvironment{inthisdocumenttwo}%
  {
  \hypersetup{linkcolor=arrowtextcolor}
  \vspace*{-1.3em}\noindent\color{arrowtextcolor}\small{\textsf{IN THIS DOCUMENT}}
  \vspace*{-0.5em}}%
  {\vspace*{\inthisdocumentbot}
  {\color{arrowcolor}{\rule{\linewidth}{0.06cm}}}\\[\inthisdocumentskip]
  \par}


\newlength{\alen}

\newenvironment{inthispart}%
  {\begin{fullwidth}
   %\hypersetup{linkcolor=arrowtextcolor}
  \vspace*{1em}
  \settowidth{\alen}{\Forward}\addtolength{\alen}{4pt}%
  \small\textls{\textsf{CONTENTS}} \\
  \vspace{-1.3em}
  \begin{adjustwidth}{-\alen}{}%
  \begin{arrow}}%
  {\end{arrow}\vspace*{\inthisdocumentbot}
   \end{adjustwidth}%
   \end{fullwidth}
  \par}


\newenvironment{inthiscollection}%
  {\begin{fullwidth}
   %\hypersetup{linkcolor=arrowtextcolor}
  \vspace*{1em}
  \settowidth{\alen}{\Forward}\addtolength{\alen}{4pt}%
  \small\textls{\textsf{CONTENTS}} \\
  \vspace{-1.3em}
  \begin{adjustwidth}{-\alen}{}%
  \begin{arrow}}%
  {\end{arrow}\vspace*{\inthisdocumentbot}
   \end{adjustwidth}%
   \end{fullwidth}
  \par}

% XC Syntax
\newlength{\codeindent}
\setlength{\codeindent}{3pt}
\lstset{backgroundcolor=\color{lightgrey},aboveskip=\baselineskip,belowskip=3pt}

\lstdefinelanguage{XC} {sensitive=true, morestring=[b]",}
%\definecolor{framegray}{gray}{0.75}
\lstset{%
   frame=single,framerule=0.4pt,rulecolor=\color{xmoslightgrey}, rulesepcolor=\color{xmoslightgrey},
   showspaces=false,showstringspaces=false,showtabs=false,
   keywordstyle=\bfseries,%
   %escapechar=\%,
   literate={@}{{\tiny{\MVAt}}}1,
   xleftmargin=\codeindent,xrightmargin=0pt,language=XC,basicstyle=\ttfamily\small}
% \lstset{prebreak=\raisebox{-0.5ex}[0ex][0ex]
%   {{\normalsize \ensuremath{\hookleftarrow}}}}
 \lstset{postbreak=\raisebox{0ex}[0ex][0ex]
   {{\normalsize \ensuremath{\hookrightarrow\space}}}}
 \lstset{breaklines=true, breakindent=10pt}

% FIX
% Trick for commands to make spacing work on second line
\newlist{commands}{description}{1}
\setlist[commands]{leftmargin=22mm, topsep=0pt, partopsep=0pt, style=nextline}
%\newcommand{\command}[1]{\begin{commands}\item #1\end{commands}}

\newcommand{\command}[1]{\begin{features}\item \texttt{#1}\end{features}}
\newcommand{\xtacommand}[1]{> \hspace*{\gdbpwidthb}\texttt{#1}}


% Colors
\definecolor{black}{rgb}{0,0,0}
\definecolor{white}{rgb}{1,1,1}
\definecolor{yell}{rgb}{1,0.847,0.118}
\definecolor{darkgreen}{rgb}{0,0.7,0}
\definecolor{darkblue}{rgb}{0,0,0.6}

\definecolor{brightred}{rgb}{1.00, 0.12, 0.00}
\definecolor{brightgreen}{rgb}{0.02, 0.98, 0.00}
\definecolor{brightblue}{rgb}{0.20, 0.41, 1.00}

\definecolor{cornflowerblue}{rgb}{0.392,0.584,0.929}%100-149-237

\definecolor{lightred}{rgb}{1.0, 0.878, 0.878}
\definecolor{darkred}{rgb}{0.35, 0, 0}

\definecolor{darkblue}{rgb}{0, 0, 0.35}

\definecolor{pastelyell}{rgb}{1.00, 1.00, 0.60}
\definecolor{pastelpink}{rgb}{0.80, 0.62, 1.00}
\definecolor{pastelgreen}{rgb}{0.79, 0.99, 0.80}
\definecolor{pastelorange}{rgb}{1.00, 0.80, 0.60}
\definecolor{pastelblue}{rgb}{0.59, 0.80, 1.00}

\definecolor{paleblue}{rgb}{0.80, 1.00, 1.00}
\definecolor{babyblue}{rgb}{0.79, 1.00, 1.00}

\definecolor{lightgrey}{gray}{0.935}%used to be 0.93
\definecolor{darkgrey}{gray}{0.3}

\definecolor{xmosyellow}{rgb}{1, 0.78, 0.18}

% Symbols

% New define for tt for internationalisation of tt fonts
\newcommand{\Texttt}[1]{\texttt{#1}}

%\newcommand{\ttsquote}{\verb+'+ } % requires upquote (see below) 
\newcommand{\seesec}[1]{\emph{see} \Sec~\ref{#1}}
\newcommand{\seesecnum}[1]{\emph{see} \Sec~#1}
\newcommand{\Seesec}[1]{\emph{See} \Sec~\ref{#1}}
\newcommand{\Seesecnum}[1]{\emph{See} \Sec~#1}
\newcommand{\seefig}[1]{\emph{see} \figurename~\ref{#1}}
\newcommand{\Sec}{\S$\!\!$}
\newcommand{\Y}{\ding{51}} % requires pifont, fix move to here
\newcommand{\N}{\ding{55}} % requires pifont, fix move to here
\newcommand{\ttbslash}{\texttt{\char`\\}}
\newcommand{\ttlbrace}{\texttt{\char`\{}}
\newcommand{\ttrbrace}{\texttt{\char`\}}}
\newcommand{\ttcaret}{\textasciicircum}
\newcommand{\tildesym}{\textasciitilde}
\newcommand{\lebnf}{$\langle$}
\newcommand{\rebnf}{$\rangle$}
\newcommand{\escape}[1]{\Texttt{\ttbslash #1}}
\newcommand{\token}[1]{\textnormal{\texttt{#1}}}
\newcommand{\newinxc}{${\textrm{\small{\textsf{NEW}}}\atop{\textrm{\colorbox{black}{\color{white}\small{\textsf{XC}}}}}}$}
\newcommand{\optionalS}[1]{\ifthenelse{#1 > 1}{s}{}}

% Add \Toprule to set of \toprule, \midrule, \bottomrule
\newcommand\Toprule{\toprule[0.6mm]}
\newcommand\Midrule{\midrule[0.3mm]}
\newcommand\Bottomrule{\bottomrule[0.6mm]}
\arrayrulecolor{xmoslightgrey}
\def\sphinxhyphen{--}

% Margin Symbols
% Books have margins on both sides, all others on left only

% The ideal height of an icon on a single line is one baselineskip
% The ideal height of an icon on n lines is (n-1)baselineskip + height of ]
\newlength{\iconht}
\newcommand{\calciconspace}[1]{\ifthenelse{\equal{#1}{1}}{\setlength\iconht{\baselineskip}}{%
\settoheight\iconht{\textsf{]}}\addtolength\iconht{#1\baselineskip}\addtolength\iconht{-\baselineskip}}}
\newlength{\iconadj}
\newlength{\iconadjraise}
\newlength{\icongap}
\newlength{\iconcenter}
% Adjust for icons to align with top of text on first line
% Sometimes want to vertically center on a single line too
\newcommand{\calciconadj}{\settoheight\iconadj{\textsf{]}}\setlength\iconadj{-\iconadj}%
\setlength{\icongap}{\iconht+\iconadj}%
\setlength{\iconcenter}{\icongap/2}%
\setlength\iconadjraise{\iconadj-\iconcenter}}

% LATEX MAGIC!!!
% The class file uses \enlargethispage to add documentation information
% to the bottom of the first page.
% However, including an image on the first page (or floating to next) appears
% to undo the effect of \enlargethispage. This applies to
% the use of images in \marginpar.
% MAGIC: Adding \enlargethispage{0cm} afterwards seems to fix!

\newcommand{\DocumentFooterFix}{\enlargethispage{0cm}}
% The marginpar calls below perform the fix automatically
% The RST generator should also generate this command after all figures

\newcommand{\textmargin}[1]{\reversemarginpar\marginpar{\flushright{#1}}}
\newcommand{\pencilmargin}{\reversemarginpar\marginpar{\flushright{\huge{\ding{46}}}}\ifen\ \fi}
\newcommand{\newinxcmargin}{\reversemarginpar\marginpar{\flushright{\huge{\vspace*{-0.21cm}\newinxc}}}\ifen\ \fi\DocumentFooterFix}
\newcommand{\newinxcmarginraise}{\newinxcmargin}

\newcommand{\reddotmargin}{\reversemarginpar\marginpar{\flushright{\color{red}{\LARGE\textbullet}}}}
\newcommand{\ambderdotmargin}{\reversemarginpar\marginpar{\flushright{\color{xmosyellow}{\LARGE\textbullet}}}}
\newcommand{\greendotmargin}{\reversemarginpar\marginpar{\flushright{\color{green}{\LARGE\textbullet}}}}

\newcommand{\iconmargin}[2]{%
\calciconspace{#1}\calciconadj%
\reversemarginpar\marginpar{\hfill\vtop{\vskip\iconadj%
\hbox{\ifthenelse{\@infullwidth=1}{\hspace*{-26mm}}{}\includegraphics[height=\iconht]{#2}}}}\xspace\DocumentFooterFix}

\newcommand{\iconmarginraise}[2]{%
\calciconspace{#1}\calciconadj%
\reversemarginpar\marginpar{\hfill\vtop{\vskip\iconadjraise%
\hbox{\ifthenelse{\@infullwidth=1}{\hspace*{-26mm}}{}\includegraphics[height=\iconht]{#2}}}}\xspace\DocumentFooterFix}

\newcommand{\doubleiconmargin}[3]{%
\calciconspace{#1}\calciconadj%
\reversemarginpar\marginpar{\hfill\vtop{\vskip\iconadj%
\hbox{\includegraphics[height=\iconht]{#2} \includegraphics[height=\iconht]{#3}}}}\xspace\DocumentFooterFix}

\newcommand{\doubleiconmarginraise}[3]{%
\calciconspace{#1}\calciconadj%
\reversemarginpar\marginpar{\hfill\vtop{\vskip\iconadjraise%
\hbox{\includegraphics[height=\iconht]{#2} \includegraphics[height=\iconht]{#3}}}}\xspace\DocumentFooterFix}


\newcommand{\tipmargin}{\iconmargin{2}{tipmargin}}
\newcommand{\tipmarginraise}{\iconmarginraise{2}{tipmargin}}
\newcommand{\infomargin}{\iconmargin{2}{notifymargin}}
\newcommand{\infomarginraise}{\iconmarginraise{2}{notifymargin}}
\newcommand{\attentionmargin}{\iconmargin{2}{warnmargin}}
\newcommand{\attentionmarginraise}{\iconmarginraise{2}{warnmargin}}
\newcommand{\dangermargin}{\iconmargin{2}{dangermargin}}
\newcommand{\dangermarginraise}{\iconmarginraise{2}{dangermargin}}
% Microtype adjustment to windows logo, bring into margin a little
\newcommand{\windowsmargin}{\setlength{\marginparwidth}{19.2mm}\iconmargin{2}{windowsmargin}\setlength{\marginparwidth}{18mm}}
\newcommand{\macmargin}{\iconmargin{2}{macmargin}}
\newcommand{\linuxmargin}{\iconmargin{2}{linuxmargin}}

% Table tightness, default to usual values
\newcommand{\loosertables}{\renewcommand{\arraystretch}{1.40}}
\newcommand{\loosetables}{\renewcommand{\arraystretch}{1.25}}
\newcommand{\tighttables}{\renewcommand{\arraystretch}{1.00}} %default
\loosetables

% Document Captions
% \regularcaption provides the same interface as memoir's \sidecaption
\newcommand{\regularcaption}{\@ifnextchar [{\@regularcaption}{\@regularcaption[]}}
\def\endregularsidecaption{}
\def\@regularcaption[#1]#2{%
  \@ifnextchar [{\@@regularcaption{#1}{#2}}{\@@regularcaption{#1}{#2}[]}}
\def\@@regularcaption#1#2[#3]{%
  \ifx\@empty#1\@empty
    \def\m@mscap@fortoc{#2}%
  \else
    \def\m@mscap@fortoc{#1}%
  \fi
  \ifx\@empty#1\@empty
	\caption{#2}%
  \else
    \caption[#1]{#2}%
  \fi
  \ifx\@empty#3\@empty
  \else
    \label{#3}%
  \fi}
\let\savedsidecaption\sidecaption
\let\sidecaption\savedsidecaption
\let\savedendsidecation\endsidecaption
\newcommand{\regularfullwidthcaption}{\begin{fullwidth}\@ifnextchar [{\@regularcaption}{\@regularcaption[]}}
\def\endregularfullwidthcaption{\end{fullwidth}}

% FIX, this looks broken, maybe should be deleted (as sidecaption used)
% FIX, maybe need to style \caption (for articles)
\newcommand{\tablecaption}[2][\@empty]{
\captionnamefont{\ifen\scshape\fi\hfill}
\captiondelim{\hfill}
\captionstyle{\centerlastline\\}
\ifen\captiontitlefont{\scshape}\fi
\setlength{\belowcaptionskip}{10pt}
\ifx #1\@empty \caption{#2}\else \caption[#1]{#2}\fi}

\newcommand{\fullwidthcaption}[2][\@empty]{
\captionnamefont{\ifen\scshape\fi\hfill}
\captiondelim{\hfill}
\captionstyle{\centerlastline\\}
\ifen\captiontitlefont{\scshape}\fi
\setlength{\belowcaptionskip}{10pt}
\ifx #1\@empty \caption{#2}\else \caption[#1]{#2}\fi}

\newlength{\widelength}
\setlength{\widelength}{0.7in}

\newlength{\syntaxlen}
\newlength{\grammarindentlen}
\newenvironment{grammar}[2][0pt]{\setlength{\grammarindentlen}{\blockindentlen}\addtolength{\grammarindentlen}{#1}\settowidth{\syntaxlen}{#2\ }\begin{em}\hspace*{\grammarindentlen}\small\begin{tabular}{@{}p{\syntaxlen}@{~}c@{~~}l}}{\end{tabular}\end{em}}%
\newcommand{\ebnf}[2]{\ifthenelse{\equal{#1}{opt}}{#2$_{\mathrm{\emph{opt}}}$}{\ifthenelse{\equal{#1}{0}}%
   {\lebnf#2\rebnf$^*$}{\ifthenelse{\equal{#1}{1}}{\lebnf#2\rebnf$^\textrm{\tiny{+}}$}{ERROR}}}}
\newcommand{\is}{\texttt{\em:\hspace*{-2pt}:\hspace*{-1pt}=}}
\newcommand{\choice}{\texttt{\em |}}
\newcommand{\oneof}{\textit{one of}}
\newcommand{\opsep}{~~~}
\newcommand{\xclang}[1]{\textit{#1}}

\newcommand{\linkdesc}[2]{\ifonline\htmladdnormallink{#2}{#1}\else#1\fi}
\newcommand{\xurldesc}[2]{\ifonline\htmladdnormallink{\textbf{#2}}{#1}\else\textbf{#1}\fi} % OBSOLETE, FIX by deleting
\newcommand{\xurl}[1]{\xurldesc{#1}{\texttt{#1}}} % OBSOLETE, FIX by deleting
\newcommand{\shortcut}[1]{\emph{#1}} % OBSOLETE, FIX by deleting
\newcommand{\linkdocnum}[1]{\linkdesc{http://www.xmos.com/docnum/#1}{#1}}
\newcommand{\documentnumber}[1]{document number \linkdocnum{#1}}
\newcommand{\trianglenote}[1]{\begin{features}\item #1\end{features}} % OBSOLETE, FIX by deleting
\newcommand{\parurl}[1]{\trianglenote{\xurl{#1}}}

% Specifications (fix - move to xcuser guide as this is only place used)
\newenvironment{spec}{\small\lstset{basicstyle=\ttfamily\footnotesize,xleftmargin=10pt}}{\normalsize\lstset{basicstyle=\ttfamily\small,xleftmargin=\codeindent}}

% Code display container
\newenvironment{verbcode}{}{}

% Terms
% LaTeX macros for XMOS terminology

% Localisation Spacing (as current LaTex 
% system cannot properly space between
% Roman and Asian characters
\newcommand{\xxspace}{\ifen\xspace\fi}

% Company and Brands
\newcommand{\xmos}{XMOS\xxspace}
\newcommand{\xcore}{xCORE Tile\xxspace}
\newcommand{\xcores}{xCORE Tiles\xxspace}
\newcommand{\xlink}{xConnect Link\xxspace}
\newcommand{\xlinks}{xConnect Links\xxspace}

% Terms
\newcommand{\multicore}{multicore\xspace}
\newcommand{\multichip}{multi-chip\xspace}

% Languages
\newcommand{\xc}{\mbox{XC}\xxspace}
\newcommand{\ansic}{C\xxspace}
\newcommand{\cpp}{\mbox{C++}\xxspace}
\newcommand{\xn}{\mbox{XN}\xxspace}

% File Formats
\newcommand{\xe}{\mbox{XE}\xxspace}
\newcommand{\xb}{\mbox{XB}\xxspace}
\newcommand{\elf}{\mbox{ELF}\xxspace}

% Tools
\newcommand{\tools}{Tools\xxspace}
\newcommand{\xtools}{\xmos tools\xxspace}
\newcommand{\xde}{\xmos Development Environment\xxspace}
\newcommand{\XDE}{XDE\xxspace}
\newcommand{\xcc}{XCC\xxspace}
\newcommand{\xas}{XAS\xxspace}
\newcommand{\xmap}{XMAP\xxspace}
\newcommand{\xta}{XTA\xxspace}
\newcommand{\xgdb}{XGDB\xxspace}
\newcommand{\xsim}{XSIM\xxspace}
\newcommand{\xrun}{XRUN\xxspace}
\newcommand{\xflash}{XFLASH\xxspace}
\newcommand{\xburn}{XBURN\xxspace}
\newcommand{\xobjdump}{XOBJDUMP\xxspace}
\newcommand{\xvcd}{XVCD\xxspace}
\newcommand{\libflash}{libflash\xxspace}
\newcommand{\xscope}{XScope\xxspace}

% Development Boards
\newcommand{\xdk}{XDK\xxspace}
\newcommand{\XDK}{XS1-G Development Kit\xxspace}
\newcommand{\xcard}[1]{\mbox{XC-#1}\xxspace}
\newcommand{\XCARD}[1]{\ifthenelse{\equal{#1}{1}}{XC-1 Development Kit}{%
                       \ifthenelse{\equal{#1}{2}}{XC-2 Ethernet Kit}{%
                       \ifthenelse{\equal{#1}{3}}{XC-3 LED Tile Control Kit}{%
                       \ifthenelse{\equal{#1}{5}}{XC-5 Development Kit}{%
                       ERROR}}}}}
\newcommand{\xk}[1]{\mbox{XK-#1}\xspace}
\newcommand{\xtag}{XTAG\xspace}
\newcommand{\xtagii}{XTAG-2\xspace}
\newcommand{\xnd}[1]{X\emph{n}D#1\xspace}
\newcommand{\xd}[1]{XD#1}

% XDE Terms
\newcommand{\projexplorer}{\textit{Project Explorer}\xspace}
\newcommand{\fname}[1]{\emph{#1}\xspace}
\newcommand{\button}[1]{\textsf{\textbf{#1}}\xspace}
\newcommand{\window}[1]{\textsf{\textbf{#1}}\xspace}
\newcommand{\menu}[1]{\textsf{\textbf{#1}}\xspace}
\newcommand{\submenu}{\Forward\ }
\newcommand{\icon}[1]{\textsf{\textbf{#1}}\xspace}
\newcommand{\optionname}[1]{\textsf{\textbf{#1}}\xspace}
\newcommand{\function}[1]{\textsf{\texttt{#1}}\xspace}
\newcommand{\opens}{opens\xspace}
\newcommand{\chose}{choose\xspace}
\newcommand{\Chose}{Choose\xspace}
\newcommand{\field}[1]{\emph{#1}}

\DeclareRobustCommand{\dec}{-\mbox{-}}
\DeclareRobustCommand{\lshift}{<\mbox{<}}
\DeclareRobustCommand{\lshifteq}{<\mbox{<}=}
\DeclareRobustCommand{\rshift}{>\mbox{>}}
\DeclareRobustCommand{\rshifteq}{>\mbox{>}=}
\newcommand{\view}[1]{\textsf{\textit{#1}} view\xspace}
\newcommand{\tab}[1]{\textsf{\textit{#1}} tab\xspace}
\newcommand{\perspec}[1]{\textsf{\textit{#1}} perspective\xspace}
\newcommand{\panel}[1]{\textsf{\textit{#1}} panel\xspace}
\newcommand{\dbox}[1]{\textsf{\textit{#1}} dialog box\xspace}
\newcommand{\ctrl}{Ctrl (Windows, Linux) or \mbox{\CloverLeaf (Mac)}\xspace}
\newcommand{\expandicon}{plus sign (Windows) or the disclosure triangle (Mac)\xspace}

\newcommand{\mtxt}[1]{$\mathit{#1}$}
\newcommand{\mtab}[1]{$\mathit{#1}$}
\newcommand{\inst}[1]{\textsf{#1}}




% Welcome (fix - move to xcuser guide as this is only place used)
\newcommand{\welcome}[1]{\ifonline\else%
\chapter*{#1}%
\markboth{#1}{#1}%
\input{welcome}%
\clearemptydoublepage%
\fi}

% Bibliography

\bibliographystyle{unsrt}
\newcommand{\xmosbib}{\bibliography{xmos}}

\renewcommand*{\bibname}{Related Documents}
\ifnochapters
% Ensure bibliography is a standard numbered section
\renewcommand{\bibsection}{\section{\bibname}}
\else
\renewcommand{\bibsection}{%
\chapter{\bibname}
\bibmark
%\ifnobibintoc\else
%\phantomsection
%\addcontentsline{toc}{chapter}{\bibname}
%\fi
\prebibhook
}
\fi

\renewenvironment{thebibliography}[1]{%
\bibsection
\begin{fullwidth}
\begin{bibitemlist}{#1}}%
{\end{bibitemlist}\end{fullwidth}\postbibhook}

% Index
\newcommand{\xmosindex}{\begin{footnotesize}\printindex\newpage\end{footnotesize}}
\newcommand{\indexheadchar}[1]{\ifthenelse{\equal{#1}{Symbols}}{}{%
                               \ifthenelse{\equal{#1}{Default}}{}{%
                               {\bfseries\large\sffamily\quad\quad #1}}}}

% Document Numbers (options from Makefile override number specified in latex file)
\newcommand{\docnum}[2]{\ifdefined\atDocumentNumber\else\def\atDocumentNumber{#1}\fi\setcounter{revcounter}{#2}\def\atDocumentRevision{\Alph{revcounter}}}

% Tools Version
\newcommand{\toolsversion}[1]{\def\atToolsVersionNumber{#1}}

% Revisions
\newtoks{\revisiontoks}  
\revisiontoks={}
\def\revisionflag{0}
\def\activeflag{1}
\newcounter{revcounter}
\setcounter{revcounter}{0}
% FIX depricate
\newcommand{\setLatestRevision}[1]{\setcounter{revcounter}{#1}\def\atDocumentRevision{\Alph{revcounter}}}
\newcommand{\pushRevision}[1]{\revisiontoks=\expandafter{\the\revisiontoks\item #1}\def\revisionflag{1}}
\newcommand{\popRevisions}[1]{\ifthenelse{\equal{\activeflag}{1}}{\ifthenelse{\equal{\revisionflag}{1}}{\ifthenelse{\value{revcounter}>0}{\item\textbf{\ifdefined\atDocumentNumber\atDocumentNumber\Alph{revcounter}--\fi#1}\addtocounter{revcounter}{-1}\begin{revisions}\the\revisiontoks\end{revisions}\revisiontoks={}\def\revisionflag{0}}{\item ERROR: Not enough revision numbers\def\revisionerror{1}}}{}}{}}

% Final Typesetting
% changes to page length
\newcommand{\pfinallongpage}{\ifonline\else\enlargethispage{\baselineskip}\fi}
\newcommand{\pfinalshortpage}{\ifonline\else\enlargethispage{-\baselineskip}\fi}
\newcommand{\pfinalforcedpage}{\ifonline\else\enlargethispage*{\baselineskip}\fi}
% correct latex's decision about when to start a new page
\newcommand{\pfinalpagebreak}{\ifonline\else\pagebreak\fi}
\newcommand{\pfinalnewpage}{\ifonline\else\newpage\fi}
% add or subtract tiny bits of vertical space to improve visual appearance
\newcommand{\pfinalfixedskip}[1]{\ifonline\else\vspace*{#1}\fi}
\newcommand{\pfinalfill}{\ifonline\else\vspace*{\fill}\fi}
\newcommand{\pfinalnewline}{\ifonline\else\newline\fi}
\newcommand{\pfinalspace}{\ifonline\else\ \fi}

\newcommand{\wfinallongpage}{\ifonline\enlargethispage{\baselineskip}\fi}
\newcommand{\wfinalshortpage}{\ifonline\enlargethispage{-\baselineskip}\fi}
\newcommand{\wfinalforcedpage}{\ifonline\enlargethispage*{\baselineskip}\fi}
% correct latex's decision about when to start a new page
\newcommand{\wfinalpagebreak}{\ifonline\pagebreak\fi}
\newcommand{\wfinalnewpage}{\ifonline\newpage\fi}
% add or subtract tiny bits of vertical space to improve visual appearance
\newcommand{\wfinalfixedskip}[1]{\ifonline\vspace*{#1}\fi}
\newcommand{\wfinalfill}{\ifonline\vspace*{\fill}\fi}
\newcommand{\wfinalkillfooter}{\ifonline\thispagestyle{nofooter}\fi}

\newcommand{\finalchapter}[2]{\ifonline\setlength{\afterchapskip}{#2\baselineskip}\fi\chapter{#1}\ifonline\setlength{\afterchapskip}{5\baselineskip}\fi}

\newcommand{\finalmbox}[1]{\mbox{#1}}
\newcommand{\finallineadj}[1]{\mbox{#1}}

\makeatletter
\def\ScaleIfNeeded{%
  \ifdim\Gin@nat@width>\linewidth
    \linewidth
  \else
    \Gin@nat@width
  \fi
}
\makeatother


% For the sphinx generator we specify the toc at the back


\newcommand{\pretoc}{}
\newcommand{\posttoc}{}


% Move deprecations here! FIX!

%\newcommand{\fullwidthsubsecadjust}{\setsubsecindent{-22mm}}
%\newcommand{\fullwidthsubsecrevert}{\setsubsecindent{0mm}}

%\printinunitsof{mm}
%\stockvalues

\newenvironment{nstabbing}
  {\setlength{\topsep}{0pt}%
   \setlength{\partopsep}{0pt}%
   \vspace{-1.5\baselineskip}
   \tabbing}
  {\endtabbing}

\newlength{\apilargeindentlen}
\setlength{\apilargeindentlen}{21mm}
\newlength{\apismallindentlen}
\setlength{\apismallindentlen}{5mm}

\newlist{apilist}{description}{1}
\setlist[apilist]{font=\normalfont\ttfamily, leftmargin=22mm,
  itemsep=0.5\baselineskip, parsep=0.5\baselineskip, style=nextline, topsep=0pt}

\RequirePackage{environ}
\RequirePackage{fancyvrb}
\RecustomVerbatimEnvironment{Verbatim}{Verbatim}{fontsize=\tiny}

\newsavebox\apibox
\newlength\apibreaklength
\setlength\apibreaklength{0.7\textheight}
\newcommand\typesetapi[1]{%
  \BODY
}
\NewEnviron{api}{%
  \savebox{\apibox}{\parbox{\linewidth}{%
    \typesetapi{\BODY}%
  }}%
  \ifdim
      \dimexpr\ht\apibox+\dp\apibox\relax 
      > \apibreaklength
    \typesetapi{\BODY}%
  \else
    \par\noindent\usebox\apibox
  \fi
  \bigskip
}

\definecolor{ifunctioncolor}{rgb}{0.96, 0.96, 0.96}

\newcommand{\xsoftipheader}{}
\def\xmosappendix{\appendix\gdef\thesection{\Alph{section}}}
\def\titleformat#1#2#3#4#5{}

\newcounter{preferredtocdepth}
\ifshortform
  \setcounter{preferredtocdepth}{1}
\else
  \setcounter{preferredtocdepth}{2}
\fi
